/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.license;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.wicket.util.diff.Diff;
import org.apache.wicket.util.diff.Revision;
import org.apache.wicket.util.license.AbstractLicenseHeaderHandler;

class CssLicenseHeaderHandler
extends AbstractLicenseHeaderHandler {
    public CssLicenseHeaderHandler(List<String> ignoreFiles) {
        super(ignoreFiles);
    }

    @Override
    protected String getLicenseHeaderFilename() {
        return "cssLicense.txt";
    }

    @Override
    public boolean checkLicenseHeader(File file) {
        Revision revision = null;
        try {
            String header = this.extractLicenseHeader(file, 0, 16);
            revision = Diff.diff(this.getLicenseHeader().split(LINE_ENDING), header.split(LINE_ENDING));
        }
        catch (Exception e) {
            throw new AssertionError((Object)e.getMessage());
        }
        return revision.size() == 0;
    }

    @Override
    public List<String> getSuffixes() {
        return Arrays.asList("css");
    }

    @Override
    public boolean addLicenseHeader(File file) {
        this.prependLicenseHeader(file);
        return true;
    }
}

