/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authroles.authorization.strategies.role.annotations;

import org.apache.wicket.Component;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authroles.authorization.strategies.role.AbstractRoleAuthorizationStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.Roles;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeAction;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeActions;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiation;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeInstantiations;
import org.apache.wicket.authroles.authorization.strategies.role.annotations.AuthorizeResource;
import org.apache.wicket.request.component.IRequestableComponent;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;

public class AnnotationsRoleAuthorizationStrategy
extends AbstractRoleAuthorizationStrategy {
    public AnnotationsRoleAuthorizationStrategy(IRoleCheckingStrategy roleCheckingStrategy) {
        super(roleCheckingStrategy);
    }

    public <T extends IRequestableComponent> boolean isInstantiationAuthorized(Class<T> componentClass) {
        boolean authorized = true;
        AuthorizeInstantiation classAnnotation = componentClass.getAnnotation(AuthorizeInstantiation.class);
        if (classAnnotation != null) {
            authorized = this.check(classAnnotation);
        } else {
            AuthorizeInstantiation packageAnnotation;
            Package componentPackage = componentClass.getPackage();
            if (componentPackage != null && (packageAnnotation = componentPackage.getAnnotation(AuthorizeInstantiation.class)) != null) {
                authorized = this.check(packageAnnotation);
            }
        }
        AuthorizeInstantiations authorizeInstantiationsAnnotation = componentClass.getAnnotation(AuthorizeInstantiations.class);
        if (authorizeInstantiationsAnnotation != null) {
            for (AuthorizeInstantiation authorizeInstantiationAnnotation : authorizeInstantiationsAnnotation.ruleset()) {
                if (this.check(authorizeInstantiationAnnotation)) continue;
                authorized = false;
            }
        }
        return authorized;
    }

    private <T extends IRequestableComponent> boolean check(AuthorizeInstantiation authorizeInstantiationAnnotation) {
        boolean authorized = true;
        if (authorizeInstantiationAnnotation != null) {
            authorized = this.hasAny(new Roles(authorizeInstantiationAnnotation.value()));
        }
        return authorized;
    }

    public boolean isActionAuthorized(Component component, Action action) {
        Class<?> componentClass = component.getClass();
        return this.isActionAuthorized(componentClass, action);
    }

    protected boolean isActionAuthorized(Class<?> componentClass, Action action) {
        if (!this.check(action, componentClass.getAnnotation(AuthorizeAction.class))) {
            return false;
        }
        AuthorizeActions authorizeActionsAnnotation = componentClass.getAnnotation(AuthorizeActions.class);
        if (authorizeActionsAnnotation != null) {
            for (AuthorizeAction authorizeActionAnnotation : authorizeActionsAnnotation.actions()) {
                if (this.check(action, authorizeActionAnnotation)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean check(Action action, AuthorizeAction authorizeActionAnnotation) {
        if (authorizeActionAnnotation != null && action.getName().equals(authorizeActionAnnotation.action())) {
            Roles deniedRoles = new Roles(authorizeActionAnnotation.deny());
            if (!this.isEmpty(deniedRoles) && this.hasAny(deniedRoles)) {
                return false;
            }
            Roles acceptedRoles = new Roles(authorizeActionAnnotation.roles());
            if (!this.hasAny(acceptedRoles)) {
                return false;
            }
        }
        return true;
    }

    public boolean isResourceAuthorized(IResource resource, PageParameters pageParameters) {
        Class<?> resourceClass = resource.getClass();
        boolean allowedByResourceItself = this.isResourceAnnotationSatisfied(resourceClass.getAnnotation(AuthorizeResource.class));
        boolean allowedByPackage = this.isResourceAnnotationSatisfied(resourceClass.getPackage().getAnnotation(AuthorizeResource.class));
        return allowedByResourceItself && allowedByPackage;
    }

    private boolean isResourceAnnotationSatisfied(AuthorizeResource annotation) {
        if (annotation != null) {
            return this.hasAny(new Roles(annotation.value()));
        }
        return true;
    }
}

