/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.http;

import jakarta.servlet.http.Cookie;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import org.apache.wicket.request.Response;
import org.apache.wicket.util.encoding.UrlEncoder;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public abstract class WebResponse
extends Response {
    public static final Duration MAX_CACHE_DURATION = Duration.ofDays(365L);

    public abstract void addCookie(Cookie var1);

    public abstract void clearCookie(Cookie var1);

    public abstract boolean isHeaderSupported();

    public abstract void setHeader(String var1, String var2);

    public abstract void addHeader(String var1, String var2);

    public abstract void setDateHeader(String var1, Instant var2);

    public abstract void setContentLength(long var1);

    public abstract void setContentType(String var1);

    public void setContentRange(String contentRange) {
        this.setHeader("Content-Range", contentRange);
    }

    public void setAcceptRange(String acceptRange) {
        this.setHeader("Accept-Range", acceptRange);
    }

    public void setLastModifiedTime(Instant time) {
        this.setDateHeader("Last-Modified", time);
    }

    public void setAttachmentHeader(String filename) {
        this.setHeader("Content-Disposition", "attachment" + this.encodeDispositionHeaderValue(filename));
    }

    public void setInlineHeader(String filename) {
        this.setHeader("Content-Disposition", "inline" + this.encodeDispositionHeaderValue(filename));
    }

    private String encodeDispositionHeaderValue(String filename) {
        return Strings.isEmpty((String)filename) ? "" : String.format("; filename=\"%1$s\"; filename*=UTF-8''%1$s", UrlEncoder.HEADER_INSTANCE.encode(filename, StandardCharsets.UTF_8));
    }

    public abstract void setStatus(int var1);

    public abstract void sendError(int var1, String var2);

    public abstract String encodeRedirectURL(CharSequence var1);

    public abstract void sendRedirect(String var1);

    public abstract boolean isRedirect();

    public abstract void flush();

    public void disableCaching() {
        this.setDateHeader("Date", Instant.now());
        this.setDateHeader("Expires", Instant.EPOCH);
        this.setHeader("Pragma", "no-cache");
        this.setHeader("Cache-Control", "no-cache, no-store");
    }

    public void enableCaching(Duration duration, CacheScope scope) {
        Args.notNull((Object)duration, (String)"duration");
        Args.notNull((Object)((Object)scope), (String)"scope");
        if (duration.compareTo(MAX_CACHE_DURATION) > 0) {
            duration = MAX_CACHE_DURATION;
        }
        Instant now = Instant.now();
        this.setDateHeader("Date", now);
        this.setDateHeader("Expires", now.plus(duration));
        this.setHeader("Cache-Control", scope.cacheControl);
        this.addHeader("Cache-Control", "max-age=" + Math.round(duration.getSeconds()));
        this.setHeader("Pragma", "cache");
    }

    public static enum CacheScope {
        PUBLIC("public"),
        PRIVATE("private");

        private final String cacheControl;

        private CacheScope(String cacheControl) {
            this.cacheControl = cacheControl;
        }
    }
}

