/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.spi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.unomi.api.CustomItem;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.Topic;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.campaigns.Campaign;
import org.apache.unomi.api.campaigns.events.CampaignEvent;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.goals.Goal;
import org.apache.unomi.api.rules.Rule;
import org.apache.unomi.api.segments.Scoring;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.persistence.spi.ItemDeserializer;
import org.apache.unomi.persistence.spi.PropertyTypedObjectDeserializer;

public class CustomObjectMapper
extends ObjectMapper {
    private static final long serialVersionUID = 4578277612897061535L;
    private Map<String, Class<? extends Item>> builtinItemTypeClasses = new HashMap<String, Class<? extends Item>>();
    private PropertyTypedObjectDeserializer propertyTypedObjectDeserializer;
    private ItemDeserializer itemDeserializer;

    public CustomObjectMapper() {
        this(null);
    }

    public CustomObjectMapper(Map<Class, StdDeserializer<?>> deserializers) {
        super.registerModule((Module)new JaxbAnnotationModule());
        super.registerModule((Module)new JavaTimeModule());
        this.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        ISO8601DateFormat dateFormat = new ISO8601DateFormat();
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setDateFormat((DateFormat)dateFormat);
        SimpleModule deserializerModule = new SimpleModule("PropertyTypedObjectDeserializerModule", new Version(1, 0, 0, null, "org.apache.unomi.rest", "deserializer"));
        this.propertyTypedObjectDeserializer = new PropertyTypedObjectDeserializer(null, null);
        this.propertyTypedObjectDeserializer.registerMapping("type=.*Condition", Condition.class);
        deserializerModule.addDeserializer(Object.class, (JsonDeserializer)this.propertyTypedObjectDeserializer);
        this.itemDeserializer = new ItemDeserializer();
        deserializerModule.addDeserializer(Item.class, (JsonDeserializer)this.itemDeserializer);
        if (deserializers != null) {
            deserializers.forEach((arg_0, arg_1) -> ((SimpleModule)deserializerModule).addDeserializer(arg_0, arg_1));
        }
        this.builtinItemTypeClasses = new HashMap<String, Class<? extends Item>>();
        this.builtinItemTypeClasses.put("campaign", Campaign.class);
        this.builtinItemTypeClasses.put("campaignevent", CampaignEvent.class);
        this.builtinItemTypeClasses.put("event", Event.class);
        this.builtinItemTypeClasses.put("goal", Goal.class);
        this.builtinItemTypeClasses.put("persona", Persona.class);
        this.builtinItemTypeClasses.put("profile", Profile.class);
        this.builtinItemTypeClasses.put("rule", Rule.class);
        this.builtinItemTypeClasses.put("scoring", Scoring.class);
        this.builtinItemTypeClasses.put("segment", Segment.class);
        this.builtinItemTypeClasses.put("session", Session.class);
        this.builtinItemTypeClasses.put("conditionType", ConditionType.class);
        this.builtinItemTypeClasses.put("actionType", ActionType.class);
        this.builtinItemTypeClasses.put("topic", Topic.class);
        this.builtinItemTypeClasses.put("profileAlias", ProfileAlias.class);
        for (Map.Entry<String, Class<? extends Item>> entry : this.builtinItemTypeClasses.entrySet()) {
            this.propertyTypedObjectDeserializer.registerMapping("itemType=" + entry.getKey(), entry.getValue());
            this.itemDeserializer.registerMapping(entry.getKey(), entry.getValue());
        }
        this.propertyTypedObjectDeserializer.registerMapping("itemType=.*", CustomItem.class);
        super.registerModule((Module)deserializerModule);
    }

    public void registerBuiltInItemTypeClass(String itemType, Class clazz) {
        this.propertyTypedObjectDeserializer.registerMapping("itemType=" + itemType, clazz);
        this.itemDeserializer.registerMapping(itemType, clazz);
    }

    public void unregisterBuiltInItemTypeClass(String itemType) {
        this.propertyTypedObjectDeserializer.unregisterMapping("itemType=" + itemType);
        this.itemDeserializer.unregisterMapping(itemType);
    }

    public static ObjectMapper getObjectMapper() {
        return Holder.INSTANCE;
    }

    public static CustomObjectMapper getCustomInstance() {
        return Holder.INSTANCE;
    }

    public Class<? extends Item> getBuiltinItemTypeClass(String itemType) {
        return this.builtinItemTypeClasses.get(itemType);
    }

    private static class Holder {
        static final CustomObjectMapper INSTANCE = new CustomObjectMapper();

        private Holder() {
        }
    }
}

