/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.configurator.impl;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.felix.configurator.impl.logger.SystemLogger;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class Util {
    public static final String NS_OSGI_EXTENDER = "osgi.extender";
    private static final String PROP_CONFIGURATIONS = "configurations";
    private static final String DEFAULT_PATH = "OSGI-INF/configurator";

    public static Set<String> isConfigurerBundle(Bundle bundle, long configuratorBundleId) {
        BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        if (bundleWiring == null) {
            return null;
        }
        List requirements = bundleWiring.getRequirements(NS_OSGI_EXTENDER);
        if (requirements == null || requirements.isEmpty()) {
            return null;
        }
        List wires = bundleWiring.getRequiredWires(NS_OSGI_EXTENDER);
        for (BundleWire wire : wires) {
            if (wire.getProviderWiring() == null || wire.getProviderWiring().getBundle().getBundleId() != configuratorBundleId) continue;
            Object val = wire.getRequirement().getAttributes().get(PROP_CONFIGURATIONS);
            if (val != null) {
                if (val instanceof String) {
                    return Collections.singleton((String)val);
                }
                if (val instanceof List) {
                    List paths = (List)val;
                    HashSet<String> result = new HashSet<String>();
                    for (String p : paths) {
                        result.add(p);
                    }
                    return result;
                }
                SystemLogger.error("Attribute configurations for configurator requirement has an invalid type: " + val + ". Using default configuration.");
            }
            return Collections.singleton(DEFAULT_PATH);
        }
        return null;
    }

    public static String getSHA256(String value) {
        try {
            StringBuilder builder = new StringBuilder();
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (byte b : md.digest(value.getBytes("UTF-8"))) {
                builder.append(String.format("%02x", b));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

