/*
 * Decompiled with CFR 0.152.
 */
package jakarta.mail.search;

import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.search.StringTerm;
import java.io.IOException;

public final class BodyTerm
extends StringTerm {
    private static final long serialVersionUID = -4888862527916911385L;

    public BodyTerm(String pattern) {
        super(pattern);
    }

    @Override
    public boolean match(Message message) {
        try {
            return this.matchPart(message);
        }
        catch (IOException e) {
            return false;
        }
        catch (MessagingException e) {
            return false;
        }
    }

    private boolean matchPart(Part part) throws MessagingException, IOException {
        if (part.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (!this.matchPart(bp)) continue;
                return true;
            }
            return false;
        }
        if (part.isMimeType("text/*")) {
            String content = (String)part.getContent();
            return super.match(content);
        }
        if (part.isMimeType("message/rfc822")) {
            return this.matchPart((Part)part.getContent());
        }
        return false;
    }
}

