/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.jsl;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.batchee.jaxb.Batchlet;
import org.apache.batchee.jaxb.CheckpointAlgorithm;
import org.apache.batchee.jaxb.Chunk;
import org.apache.batchee.jaxb.ExceptionClassFilter;
import org.apache.batchee.jaxb.ItemProcessor;
import org.apache.batchee.jaxb.ItemReader;
import org.apache.batchee.jaxb.ItemWriter;
import org.apache.batchee.jaxb.JSLProperties;
import org.apache.batchee.jaxb.Listener;
import org.apache.batchee.jaxb.Listeners;
import org.apache.batchee.jaxb.ObjectFactory;
import org.apache.batchee.jaxb.Property;

public class CloneUtility {
    private static final ObjectFactory JSL_FACTORY = new ObjectFactory();

    private CloneUtility() {
    }

    public static Batchlet cloneBatchlet(Batchlet batchlet) {
        Batchlet newBatchlet = JSL_FACTORY.createBatchlet();
        newBatchlet.setRef(batchlet.getRef());
        newBatchlet.setProperties(CloneUtility.cloneJSLProperties(batchlet.getProperties()));
        return newBatchlet;
    }

    public static JSLProperties cloneJSLProperties(JSLProperties jslProps) {
        if (jslProps == null) {
            return null;
        }
        JSLProperties newJSLProps = JSL_FACTORY.createJSLProperties();
        newJSLProps.setPartition(jslProps.getPartition());
        for (Property jslProp : jslProps.getPropertyList()) {
            Property newProperty = JSL_FACTORY.createProperty();
            newProperty.setName(jslProp.getName());
            newProperty.setValue(jslProp.getValue());
            newJSLProps.getPropertyList().add(newProperty);
        }
        return newJSLProps;
    }

    public static Listeners cloneListeners(Listeners listeners) {
        if (listeners == null) {
            return null;
        }
        Listeners newListeners = JSL_FACTORY.createListeners();
        for (Listener listener : listeners.getListenerList()) {
            Listener newListener = JSL_FACTORY.createListener();
            newListeners.getListenerList().add(newListener);
            newListener.setRef(listener.getRef());
            newListener.setProperties(CloneUtility.cloneJSLProperties(listener.getProperties()));
        }
        return newListeners;
    }

    public static Chunk cloneChunk(Chunk chunk) {
        Chunk newChunk = JSL_FACTORY.createChunk();
        newChunk.setItemCount(chunk.getItemCount());
        newChunk.setRetryLimit(chunk.getRetryLimit());
        newChunk.setSkipLimit(chunk.getSkipLimit());
        newChunk.setTimeLimit(chunk.getTimeLimit());
        newChunk.setCheckpointPolicy(chunk.getCheckpointPolicy());
        newChunk.setCheckpointAlgorithm(CloneUtility.cloneCheckpointAlorithm(chunk.getCheckpointAlgorithm()));
        newChunk.setProcessor(CloneUtility.cloneItemProcessor(chunk.getProcessor()));
        newChunk.setReader(CloneUtility.cloneItemReader(chunk.getReader()));
        newChunk.setWriter(CloneUtility.cloneItemWriter(chunk.getWriter()));
        newChunk.setNoRollbackExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getNoRollbackExceptionClasses()));
        newChunk.setRetryableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getRetryableExceptionClasses()));
        newChunk.setSkippableExceptionClasses(CloneUtility.cloneExceptionClassFilter(chunk.getSkippableExceptionClasses()));
        return newChunk;
    }

    private static CheckpointAlgorithm cloneCheckpointAlorithm(CheckpointAlgorithm checkpointAlgorithm) {
        if (checkpointAlgorithm == null) {
            return null;
        }
        CheckpointAlgorithm newCheckpointAlgorithm = JSL_FACTORY.createCheckpointAlgorithm();
        newCheckpointAlgorithm.setRef(checkpointAlgorithm.getRef());
        newCheckpointAlgorithm.setProperties(CloneUtility.cloneJSLProperties(checkpointAlgorithm.getProperties()));
        return newCheckpointAlgorithm;
    }

    private static ItemProcessor cloneItemProcessor(ItemProcessor itemProcessor) {
        if (itemProcessor == null) {
            return null;
        }
        ItemProcessor newItemProcessor = JSL_FACTORY.createItemProcessor();
        newItemProcessor.setRef(itemProcessor.getRef());
        newItemProcessor.setProperties(CloneUtility.cloneJSLProperties(itemProcessor.getProperties()));
        return newItemProcessor;
    }

    private static ItemReader cloneItemReader(ItemReader itemReader) {
        if (itemReader == null) {
            return null;
        }
        ItemReader newItemReader = JSL_FACTORY.createItemReader();
        newItemReader.setRef(itemReader.getRef());
        newItemReader.setProperties(CloneUtility.cloneJSLProperties(itemReader.getProperties()));
        return newItemReader;
    }

    private static ItemWriter cloneItemWriter(ItemWriter itemWriter) {
        ItemWriter newItemWriter = JSL_FACTORY.createItemWriter();
        newItemWriter.setRef(itemWriter.getRef());
        newItemWriter.setProperties(CloneUtility.cloneJSLProperties(itemWriter.getProperties()));
        return newItemWriter;
    }

    private static ExceptionClassFilter cloneExceptionClassFilter(ExceptionClassFilter exceptionClassFilter) {
        if (exceptionClassFilter == null) {
            return null;
        }
        ExceptionClassFilter newExceptionClassFilter = JSL_FACTORY.createExceptionClassFilter();
        for (ExceptionClassFilter.Include oldInclude : exceptionClassFilter.getIncludeList()) {
            newExceptionClassFilter.getIncludeList().add(CloneUtility.cloneExceptionClassFilterInclude(oldInclude));
        }
        for (ExceptionClassFilter.Exclude oldExclude : exceptionClassFilter.getExcludeList()) {
            newExceptionClassFilter.getExcludeList().add(CloneUtility.cloneExceptionClassFilterExclude(oldExclude));
        }
        return newExceptionClassFilter;
    }

    private static ExceptionClassFilter.Include cloneExceptionClassFilterInclude(ExceptionClassFilter.Include include) {
        if (include == null) {
            return null;
        }
        ExceptionClassFilter.Include newInclude = JSL_FACTORY.createExceptionClassFilterInclude();
        newInclude.setClazz(include.getClazz());
        return newInclude;
    }

    private static ExceptionClassFilter.Exclude cloneExceptionClassFilterExclude(ExceptionClassFilter.Exclude exclude) {
        if (exclude == null) {
            return null;
        }
        ExceptionClassFilter.Exclude newExclude = JSL_FACTORY.createExceptionClassFilterExclude();
        newExclude.setClazz(exclude.getClazz());
        return newExclude;
    }

    public static Properties jslPropertiesToJavaProperties(JSLProperties xmlProperties) {
        Properties props = new Properties();
        for (Property prop : xmlProperties.getPropertyList()) {
            props.setProperty(prop.getName(), prop.getValue());
        }
        return props;
    }

    public static JSLProperties javaPropsTojslProperties(Properties javaProps) {
        JSLProperties newJSLProps = JSL_FACTORY.createJSLProperties();
        Enumeration<?> keySet = javaProps.propertyNames();
        while (keySet.hasMoreElements()) {
            String key = (String)keySet.nextElement();
            String value = javaProps.getProperty(key);
            Property newProperty = JSL_FACTORY.createProperty();
            newProperty.setName(key);
            newProperty.setValue(value);
            newJSLProps.getPropertyList().add(newProperty);
        }
        return newJSLProps;
    }
}

