/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.stateful;

import java.io.File;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.stateful.PassivationStrategy;
import org.apache.openejb.spi.Serializer;
import org.apache.openejb.util.JavaSecurityManagers;

public class RAFPassivater
implements PassivationStrategy {
    int fileID;
    HashMap masterTable = new HashMap();

    @Override
    public void init(Properties props) throws SystemException {
    }

    @Override
    public synchronized void passivate(Map stateTable) throws SystemException {
        try (RandomAccessFile ras = new RandomAccessFile(JavaSecurityManagers.getSystemProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "passivation" + this.fileID + ".ser", "rw");){
            ++this.fileID;
            Iterator iterator = stateTable.keySet().iterator();
            Pointer lastPointer = null;
            while (iterator.hasNext()) {
                Object id = iterator.next();
                Object obj = stateTable.get(id);
                byte[] bytes = Serializer.serialize(obj);
                long filepointer = ras.getFilePointer();
                lastPointer = lastPointer == null ? new Pointer(this.fileID, filepointer, (int)filepointer) : new Pointer(this.fileID, filepointer, (int)(filepointer - lastPointer.filepointer));
                this.masterTable.put(id, lastPointer);
                ras.write(bytes);
            }
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    @Override
    public synchronized Object activate(Object primaryKey) throws SystemException {
        Object object;
        Pointer pointer = (Pointer)this.masterTable.get(primaryKey);
        if (pointer == null) {
            return null;
        }
        RandomAccessFile ras = new RandomAccessFile(JavaSecurityManagers.getSystemProperty("java.io.tmpdir", File.separator + "tmp") + File.separator + "passivation" + pointer.fileid + ".ser", "r");
        try {
            byte[] bytes = new byte[pointer.bytesize];
            ras.seek(pointer.filepointer);
            ras.readFully(bytes);
            object = Serializer.deserialize(bytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ras.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new SystemException(e);
            }
        }
        ras.close();
        return object;
    }

    static class Pointer {
        int fileid;
        long filepointer;
        int bytesize;

        public Pointer(int file, long pointer, int bytecount) {
            this.fileid = file;
            this.filepointer = pointer;
            this.bytesize = bytecount;
        }
    }
}

