/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.inject;

import jakarta.enterprise.inject.spi.AnnotatedParameter;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.Producer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.AbstractInjectable;

public class InjectableConstructor<T>
extends AbstractInjectable<T> {
    protected Constructor<T> con;
    private Object[] params;
    private T instance;

    public InjectableConstructor(Constructor<T> cons, InjectionTarget<T> owner, CreationalContextImpl<T> creationalContext) {
        super((Producer<?>)owner, creationalContext);
        this.con = cons;
    }

    public T doInjection() {
        try {
            if (!this.con.isAccessible()) {
                this.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible(this.con, true);
            }
            this.instance = this.con.newInstance(this.createParameters());
            this.transientCreationalContext.release();
            return this.instance;
        }
        catch (Exception e) {
            throw new WebBeansException(e);
        }
    }

    public T getInstance() {
        return this.instance;
    }

    public Object[] createParameters() {
        if (this.params != null) {
            return this.params;
        }
        ArrayList list = new ArrayList();
        List<InjectionPoint> injectedPoints = this.getInjectionPoints(this.con);
        block0: for (int i = 0; i < injectedPoints.size(); ++i) {
            for (InjectionPoint point : injectedPoints) {
                AnnotatedParameter parameter = (AnnotatedParameter)point.getAnnotated();
                if (parameter.getPosition() != i) continue;
                if (point.isDelegate()) {
                    list.add(this.creationalContext.getDelegate());
                    continue block0;
                }
                list.add(this.inject(point));
                continue block0;
            }
        }
        this.params = list.toArray(new Object[list.size()]);
        return this.params;
    }
}

