/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.support.healthcheck.thread;

import com.atlassian.support.healthcheck.Application;
import com.atlassian.support.healthcheck.DefaultSupportHealthStatus;
import com.atlassian.support.healthcheck.SupportHealthStatus;
import com.atlassian.support.healthcheck.impl.ExtendedSupportHealthCheck;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckCallable
implements Callable<SupportHealthStatus> {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckCallable.class);
    private final ExtendedSupportHealthCheck healthCheck;

    public HealthCheckCallable(ExtendedSupportHealthCheck healthCheck) {
        this.healthCheck = healthCheck;
    }

    @Override
    public SupportHealthStatus call() throws Exception {
        log.info("Invoking health check: {}", (Object)this.healthCheck.getClass().getName());
        try {
            return this.healthCheck.check();
        }
        catch (RuntimeException e) {
            return new DefaultSupportHealthStatus(false, "Exception during check invocation: " + e.getMessage(), System.currentTimeMillis(), Application.Unknown, SupportHealthStatus.Severity.UNDEFINED, "");
        }
    }
}

