/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.duo.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.duo.DuoSecurityUserAccount;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityAdminApiService;
import org.apereo.cas.adaptors.duo.authn.DuoSecurityMultifactorAuthenticationProvider;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.BaseCasRestActuatorEndpoint;
import org.jooq.lambda.Unchecked;
import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Endpoint(id="duoAdmin", defaultAccess=Access.NONE)
public class DuoSecurityAdminApiEndpoint
extends BaseCasRestActuatorEndpoint {
    public DuoSecurityAdminApiEndpoint(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
        super(casProperties, applicationContext);
    }

    @GetMapping(path={"/{username}"}, produces={"application/json"})
    @Operation(summary="Fetch Duo Security user account from Duo Admin API", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to fetch"), @Parameter(name="providerId", description="The multifactor authentication provider id defined in CAS settings")})
    public Map<String, DuoSecurityUserAccount> getUser(@PathVariable(value="username") String username, @RequestParam(required=false) String providerId) {
        LinkedHashMap<String, DuoSecurityUserAccount> results = new LinkedHashMap<String, DuoSecurityUserAccount>();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).filter(provider -> provider.getDuoAuthenticationService().getAdminApiService().isPresent()).forEach(Unchecked.consumer(p -> {
            DuoSecurityAdminApiService duoService = (DuoSecurityAdminApiService)p.getDuoAuthenticationService().getAdminApiService().orElseThrow();
            duoService.getDuoSecurityUserAccount(username).ifPresent(user -> results.put(p.getId(), (DuoSecurityUserAccount)user));
        }));
        return results;
    }

    @Operation(summary="Create bypass codes using Duo Admin API", parameters={@Parameter(name="username", required=true, in=ParameterIn.QUERY, description="The username to create bypass codes for"), @Parameter(name="providerId", description="The multifactor authentication provider id defined in CAS settings"), @Parameter(name="userId", description="The user identifier, supplied by Duo Security to create bypass codes for")})
    @PostMapping(path={"/bypassCodes"}, consumes={"application/json"}, produces={"application/json"})
    public Map<String, List<Long>> createBypassCodes(@RequestParam(value="username", required=false) String username, @RequestParam(value="providerId", required=false) String providerId, @RequestParam(value="userId", required=false) String userId) {
        LinkedHashMap<String, List<Long>> results = new LinkedHashMap<String, List<Long>>();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).filter(provider -> provider.getDuoAuthenticationService().getAdminApiService().isPresent()).forEach(Unchecked.consumer(provider -> {
            String uid;
            DuoSecurityAdminApiService duoService = (DuoSecurityAdminApiService)provider.getDuoAuthenticationService().getAdminApiService().orElseThrow();
            String string = uid = StringUtils.isBlank((CharSequence)userId) ? duoService.getDuoSecurityUserAccount(username).map(DuoSecurityUserAccount::getUserId).orElse("") : userId;
            if (StringUtils.isNotBlank((CharSequence)uid)) {
                List codes = duoService.createDuoSecurityBypassCodesFor(uid);
                results.put(provider.getId(), codes);
            }
        }));
        return results;
    }

    @PutMapping(path={"/{username}"}, produces={"application/json"})
    @Operation(summary="Update Duo Security user account from Duo Admin API", parameters={@Parameter(name="username", required=true, in=ParameterIn.PATH, description="The username to update"), @Parameter(name="providerId", description="The multifactor authentication provider id defined in CAS settings")})
    public ResponseEntity updateUser(@PathVariable(value="username") String username, @RequestParam(required=false) String providerId, @io.swagger.v3.oas.annotations.parameters.RequestBody(description="Duo user account as a JSON entity to update", required=true, content={@Content(schema=@Schema(implementation=DuoSecurityUserAccount.class))}) @RequestBody DuoSecurityUserAccount account) {
        LinkedHashMap results = new LinkedHashMap();
        Collection providers = this.applicationContext.getBeansOfType(DuoSecurityMultifactorAuthenticationProvider.class).values();
        providers.stream().filter(Objects::nonNull).filter(BeanSupplier::isNotProxy).filter(provider -> StringUtils.isBlank((CharSequence)providerId) || provider.matches(providerId)).filter(provider -> provider.getDuoAuthenticationService().getAdminApiService().isPresent()).forEach(Unchecked.consumer(provider -> {
            DuoSecurityAdminApiService duoService = (DuoSecurityAdminApiService)provider.getDuoAuthenticationService().getAdminApiService().orElseThrow();
            duoService.modifyDuoSecurityUserAccount(account.withUsername(username)).ifPresent(user -> results.put(provider.getId(), user));
        }));
        return results.isEmpty() ? ResponseEntity.notFound().build() : ResponseEntity.ok(results);
    }
}

