/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.fasterxml.jackson.jr.ob.api;

import com.signalfx.shaded.fasterxml.jackson.jr.ob.JSON;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class CollectionBuilder {
    protected static final Object[] EMPTY_ARRAY = new Object[0];
    protected final int _features;
    protected final Class<?> _collectionType;

    protected CollectionBuilder(int n, Class<?> clazz) {
        this._features = n;
        this._collectionType = clazz;
    }

    public static CollectionBuilder defaultImpl() {
        return new Default(0, null);
    }

    public abstract CollectionBuilder newBuilder(int var1);

    public abstract CollectionBuilder newBuilder(Class<?> var1);

    public CollectionBuilder newBuilder() {
        return this.newBuilder(this._features);
    }

    public final boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public abstract CollectionBuilder start();

    public abstract CollectionBuilder add(Object var1);

    public abstract Collection<Object> buildCollection();

    public Object[] buildArray() {
        Collection<Object> collection = this.buildCollection();
        return collection.toArray();
    }

    public <T> T[] buildArray(Class<T> clazz) {
        Collection<Object> collection = this.buildCollection();
        Object[] objectArray = (Object[])Array.newInstance(clazz, collection.size());
        return collection.toArray(objectArray);
    }

    public Collection<Object> emptyCollection() {
        return this.start().buildCollection();
    }

    public Object[] emptyArray() {
        return EMPTY_ARRAY;
    }

    public <T> T[] emptyArray(Class<T> clazz) {
        if (clazz == Object.class) {
            return EMPTY_ARRAY;
        }
        return (Object[])Array.newInstance(clazz, 0);
    }

    public Collection<Object> singletonCollection(Object object) {
        return this.start().add(object).buildCollection();
    }

    public Object[] singletonArray(Object object) {
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public <T> T[] singletonArray(Class<?> clazz, T t2) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, 1);
        objectArray[0] = t2;
        return objectArray;
    }

    public static class Default
    extends CollectionBuilder {
        protected Collection<Object> _current;

        protected Default(int n, Class<?> clazz) {
            super(n, clazz);
        }

        @Override
        public CollectionBuilder newBuilder(int n) {
            return new Default(n, null);
        }

        @Override
        public CollectionBuilder newBuilder(Class<?> clazz) {
            return new Default(this._features, clazz);
        }

        @Override
        public CollectionBuilder start() {
            if (this._current != null) {
                return this.newBuilder().start();
            }
            this._current = this._list(12);
            return this;
        }

        @Override
        public Collection<Object> buildCollection() {
            Collection<Object> collection = this._current;
            this._current = null;
            return collection;
        }

        @Override
        public Object[] buildArray() {
            Collection<Object> collection = this._current;
            this._current = null;
            int n = collection.size();
            Object[] objectArray = new Object[n];
            collection.toArray(objectArray);
            return objectArray;
        }

        @Override
        public CollectionBuilder add(Object object) {
            this._current.add(object);
            return this;
        }

        @Override
        public Collection<Object> emptyCollection() {
            if (this._collectionType == null && this.isEnabled(JSON.Feature.READ_ONLY)) {
                return Collections.emptyList();
            }
            return this._list(0);
        }

        protected Collection<Object> _list(int n) {
            return new ArrayList<Object>(n);
        }
    }
}

