/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pac4j.web;

import java.util.Map;
import org.apereo.cas.support.pac4j.authentication.clients.DelegatedClientsEndpointContributor;
import org.apereo.cas.util.CollectionUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.config.OAuth20Configuration;
import org.pac4j.oidc.client.OidcClient;
import org.pac4j.oidc.config.OidcConfiguration;

public class DelegatedClientsOidcEndpointContributor
implements DelegatedClientsEndpointContributor {
    public boolean supports(BaseClient client) {
        return client instanceof OAuth20Client || client instanceof OidcClient;
    }

    public Map<String, Object> contribute(BaseClient client) {
        if (client instanceof OAuth20Client) {
            OAuth20Client clientInstance = (OAuth20Client)client;
            return this.fetchOauthConfiguration(clientInstance.getConfiguration());
        }
        return this.fetchOidcConfiguration(((OidcClient)client).getConfiguration());
    }

    protected Map<String, Object> fetchOauthConfiguration(OAuth20Configuration configuration) {
        Map payload = CollectionUtils.wrap((String)"clientId", (Object)configuration.getKey(), (String)"responseType", (Object)configuration.getResponseType(), (String)"scope", (Object)configuration.getScope());
        payload.putAll(configuration.getCustomParams());
        payload.put("type", "oauth2");
        return payload;
    }

    protected Map<String, Object> fetchOidcConfiguration(OidcConfiguration configuration) {
        Map payload = CollectionUtils.wrap((String)"clientId", (Object)configuration.getClientId(), (String)"discoveryURI", (Object)configuration.getDiscoveryURI(), (String)"responseType", (Object)configuration.getResponseType(), (String)"responseMode", (Object)configuration.getResponseMode(), (String)"scope", (Object)configuration.getScope());
        payload.putAll(configuration.getCustomParams());
        payload.put("mappedClaims", configuration.getMappedClaims());
        payload.put("type", "oidc");
        return payload;
    }
}

