/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.calendar;

import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.calendar.BusinessCalendarManager;

public class MapBusinessCalendarManager
implements BusinessCalendarManager {
    private final Map<String, BusinessCalendar> businessCalendars;

    public MapBusinessCalendarManager() {
        this.businessCalendars = new HashMap<String, BusinessCalendar>();
    }

    public MapBusinessCalendarManager(Map<String, BusinessCalendar> businessCalendars) {
        if (businessCalendars == null) {
            throw new IllegalArgumentException("businessCalendars can not be null");
        }
        this.businessCalendars = new HashMap<String, BusinessCalendar>(businessCalendars);
    }

    @Override
    public BusinessCalendar getBusinessCalendar(String businessCalendarRef) {
        BusinessCalendar businessCalendar = this.businessCalendars.get(businessCalendarRef);
        if (businessCalendar == null) {
            throw new FlowableException("Requested business calendar " + businessCalendarRef + " does not exist. Allowed calendars are " + String.valueOf(this.businessCalendars.keySet()) + ".");
        }
        return businessCalendar;
    }

    public BusinessCalendarManager addBusinessCalendar(String businessCalendarRef, BusinessCalendar businessCalendar) {
        this.businessCalendars.put(businessCalendarRef, businessCalendar);
        return this;
    }
}

