/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.geo;

import java.net.InetAddress;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationResponse;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationService;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeoLocationService
implements GeoLocationService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGeoLocationService.class);

    public GeoLocationResponse locate(String address) {
        return (GeoLocationResponse)FunctionUtils.doAndHandle(() -> this.locate(InetAddress.getByName(address)), e -> null).get();
    }

    public GeoLocationResponse locate(String clientIp, GeoLocationRequest location) throws Throwable {
        LOGGER.trace("Attempting to find geolocation for [{}]", (Object)clientIp);
        GeoLocationResponse loc = this.locate(clientIp);
        if (loc == null && location != null) {
            LOGGER.trace("Attempting to find geolocation for [{}]", (Object)location);
            if (StringUtils.isNotBlank((CharSequence)location.getLatitude()) && StringUtils.isNotBlank((CharSequence)location.getLongitude())) {
                return this.locate(Double.valueOf(location.getLatitude()), Double.valueOf(location.getLongitude()));
            }
        }
        return loc;
    }

    public GeoLocationResponse locate(GeoLocationRequest request) throws Throwable {
        return this.locate(Double.valueOf(request.getLatitude()), Double.valueOf(request.getLongitude()));
    }
}

