/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.pubsub.commands;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.pubsub.QueueableTicketRegistry;
import org.apereo.cas.ticket.registry.pubsub.commands.BaseMessageQueueCommand;
import org.apereo.cas.ticket.registry.pubsub.commands.TicketAwareQueueCommand;
import org.apereo.cas.util.PublisherIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public class UpdateTicketMessageQueueCommand
extends BaseMessageQueueCommand
implements TicketAwareQueueCommand {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(UpdateTicketMessageQueueCommand.class);
    private static final long serialVersionUID = -4179190682337040669L;
    private final Ticket ticket;

    @JsonCreator
    public UpdateTicketMessageQueueCommand(@JsonProperty(value="id") PublisherIdentifier id, @JsonProperty(value="ticket") Ticket ticket) {
        super(id);
        this.ticket = ticket;
    }

    @Override
    public String getTicketId() {
        return this.ticket.getId();
    }

    @Override
    public void execute(QueueableTicketRegistry registry) throws Exception {
        LOGGER.debug("Executing queue command on ticket registry id [{}] to update ticket [{}]", (Object)this.getPublisherIdentifier().getId(), (Object)this.ticket);
        registry.updateTicketInQueue(this.ticket);
    }

    @Override
    public BaseMessageQueueCommand withPublisherIdentifier(PublisherIdentifier publisherIdentifier) {
        return new UpdateTicketMessageQueueCommand(publisherIdentifier, this.ticket);
    }

    @Generated
    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    @Generated
    public String toString() {
        return "UpdateTicketMessageQueueCommand(super=" + super.toString() + ", ticket=" + String.valueOf(this.ticket) + ")";
    }
}

