/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.expiration.builder;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.ticket.ServiceTicketProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ExpirationPolicyBuilder;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.expiration.MultiTimeUseOrTimeoutExpirationPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public record ServiceTicketExpirationPolicyBuilder(CasConfigurationProperties casProperties) implements ExpirationPolicyBuilder<ServiceTicket>
{
    private static final long serialVersionUID = -3597980180617072826L;

    public ExpirationPolicy buildTicketExpirationPolicy() {
        return this.toServiceTicketExpirationPolicy();
    }

    public ExpirationPolicy toServiceTicketExpirationPolicy() {
        ServiceTicketProperties st = this.casProperties.getTicket().getSt();
        long timeToKillInSeconds = Beans.newDuration((String)st.getTimeToKillInSeconds()).toSeconds();
        return new MultiTimeUseOrTimeoutExpirationPolicy.ServiceTicketExpirationPolicy(st.getNumberOfUses(), timeToKillInSeconds);
    }
}

