/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.authentication.attribute.AbstractDefaultAttributePersonAttributeDao;
import org.apereo.cas.authentication.attribute.CaseCanonicalizationMode;
import org.apereo.cas.authentication.attribute.SimplePersonAttributes;
import org.apereo.cas.authentication.principal.attribute.PersonAttributeDaoFilter;
import org.apereo.cas.authentication.principal.attribute.PersonAttributes;
import org.apereo.cas.authentication.principal.attribute.UsernameAttributeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedCaseInsensitiveMap;

public abstract class AbstractQueryPersonAttributeDao<QB>
extends AbstractDefaultAttributePersonAttributeDao {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractQueryPersonAttributeDao.class);
    private Map<String, Set<String>> queryAttributeMapping;
    private Map<String, Set<String>> resultAttributeMapping;
    private Map<String, CaseCanonicalizationMode> caseInsensitiveResultAttributes;
    private Map<String, CaseCanonicalizationMode> caseInsensitiveQueryAttributes;
    private CaseCanonicalizationMode defaultCaseCanonicalizationMode = CaseCanonicalizationMode.LOWER;
    private CaseCanonicalizationMode usernameCaseCanonicalizationMode = CaseCanonicalizationMode.NONE;
    private Set<String> possibleUserAttributeNames;
    private boolean requireAllQueryAttributes;
    private boolean useAllQueryAttributes = true;
    private String unmappedUsernameAttribute;

    public void setResultAttributeMapping(Map<String, ?> resultAttributeMapping) {
        Map<String, Set<String>> parsedResultAttributeMapping = AbstractQueryPersonAttributeDao.parseAttributeToAttributeMapping(resultAttributeMapping);
        Collection userAttributes = this.flattenCollection(parsedResultAttributeMapping.values());
        this.resultAttributeMapping = parsedResultAttributeMapping;
        this.possibleUserAttributeNames = new LinkedHashSet(userAttributes);
    }

    public final Set<PersonAttributes> getPeopleWithMultivaluedAttributes(Map<String, List<Object>> query, PersonAttributeDaoFilter filter, Set<PersonAttributes> resultPeople) {
        QB queryBuilder = this.generateQuery(query);
        if (queryBuilder == null && (this.queryAttributeMapping != null || this.useAllQueryAttributes)) {
            LOGGER.debug("No queryBuilder was generated for query [{}], null will be returned", query);
            return null;
        }
        UsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        String username = usernameAttributeProvider.getUsernameFromQuery(query);
        List<PersonAttributes> unmappedPeople = this.getPeopleForQuery(queryBuilder, username);
        if (unmappedPeople == null) {
            return null;
        }
        return unmappedPeople.stream().map(this::mapPersonAttributes).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    protected abstract List<PersonAttributes> getPeopleForQuery(QB var1, String var2);

    protected QB appendCanonicalizedAttributeToQuery(QB queryBuilder, String queryAttribute, String dataAttribute, List<Object> queryValues) {
        List<Object> canonicalizedQueryValues = this.canonicalizeAttribute(queryAttribute, queryValues, this.caseInsensitiveQueryAttributes);
        LOGGER.debug("Adding attribute [{}] with value [{}] to query builder [{}]", new Object[]{queryAttribute, queryValues, queryBuilder});
        return this.appendAttributeToQuery(queryBuilder, dataAttribute, canonicalizedQueryValues);
    }

    protected abstract QB appendAttributeToQuery(QB var1, String var2, List<Object> var3);

    protected final QB generateQuery(Map<String, List<Object>> query) {
        Object queryBuilder = null;
        if (this.queryAttributeMapping != null && !this.queryAttributeMapping.isEmpty()) {
            for (Map.Entry<String, Set<String>> queryAttrEntry : this.queryAttributeMapping.entrySet()) {
                String queryAttr = queryAttrEntry.getKey();
                List<Object> queryValues = query.get(queryAttr);
                if (queryValues != null) {
                    Set<String> dataAttributes = queryAttrEntry.getValue();
                    if (dataAttributes == null) {
                        queryBuilder = this.appendCanonicalizedAttributeToQuery(queryBuilder, queryAttr, null, queryValues);
                        continue;
                    }
                    for (String dataAttribute : dataAttributes) {
                        queryBuilder = this.appendCanonicalizedAttributeToQuery(queryBuilder, queryAttr, dataAttribute, queryValues);
                    }
                    continue;
                }
                if (!this.requireAllQueryAttributes) continue;
                LOGGER.debug("Query [{}] does not contain all attributes as specified in [{}]", query, this.queryAttributeMapping);
                return null;
            }
        } else if (this.useAllQueryAttributes) {
            for (Map.Entry<String, List<Object>> queryAttrEntry : query.entrySet()) {
                String queryKey = queryAttrEntry.getKey();
                List<Object> queryValues = queryAttrEntry.getValue();
                queryBuilder = this.appendCanonicalizedAttributeToQuery(queryBuilder, queryKey, queryKey, queryValues);
            }
        }
        queryBuilder = this.finalizeQueryBuilder(queryBuilder, query);
        LOGGER.debug("Generated query builder [{}] from query Map [{}]", queryBuilder, query);
        return queryBuilder;
    }

    protected QB finalizeQueryBuilder(QB queryBuilder, Map<String, List<Object>> query) {
        return queryBuilder;
    }

    protected final PersonAttributes mapPersonAttributes(PersonAttributes person) {
        Map personAttributes = person.getAttributes();
        LinkedCaseInsensitiveMap mappedAttributes = new LinkedCaseInsensitiveMap();
        if (this.resultAttributeMapping == null) {
            if (this.caseInsensitiveResultAttributes != null && !this.caseInsensitiveResultAttributes.isEmpty()) {
                for (Map.Entry<String, Set<String>> entry : personAttributes.entrySet()) {
                    String attributeName = entry.getKey();
                    mappedAttributes.put(attributeName, this.canonicalizeAttribute(attributeName, (List)((Object)entry.getValue()), this.caseInsensitiveResultAttributes));
                }
            } else {
                mappedAttributes.putAll(personAttributes);
            }
        } else {
            for (Map.Entry<String, Set<String>> entry : this.resultAttributeMapping.entrySet()) {
                String dataKey = entry.getKey();
                Set<String> resultKeys = entry.getValue();
                if (resultKeys == null) {
                    resultKeys = Set.of(dataKey);
                }
                if (resultKeys.size() == 1 && resultKeys.stream().allMatch(s -> !s.isEmpty() && s.charAt(s.length() - 1) == ';')) {
                    List<String> allKeys = personAttributes.keySet().stream().filter(name -> name.startsWith(dataKey + ";")).toList();
                    for (String resultKey : allKeys) {
                        List<Object> value = (List<Object>)personAttributes.get(resultKey);
                        value = this.canonicalizeAttribute(resultKey, value, this.caseInsensitiveResultAttributes);
                        mappedAttributes.put(resultKey, value);
                    }
                    continue;
                }
                if (!personAttributes.containsKey(dataKey)) continue;
                List<Object> value = (List<Object>)personAttributes.get(dataKey);
                for (String resultKey : resultKeys) {
                    value = this.canonicalizeAttribute(resultKey, value, this.caseInsensitiveResultAttributes);
                    if (resultKey == null) {
                        mappedAttributes.put(dataKey, value);
                        continue;
                    }
                    mappedAttributes.put(resultKey, value);
                }
            }
        }
        String name2 = person.getName();
        if (name2 != null) {
            return new SimplePersonAttributes(this.usernameCaseCanonicalizationMode.canonicalize(name2), (Map<String, List<Object>>)mappedAttributes);
        }
        String string = this.getConfiguredUserNameAttribute();
        return SimplePersonAttributes.fromAttribute(string, (Map<String, List<Object>>)mappedAttributes).canonicalize(this.usernameCaseCanonicalizationMode);
    }

    protected List<Object> canonicalizeAttribute(String key, List<Object> value, Map<String, CaseCanonicalizationMode> config) {
        if (value == null || value.isEmpty() || config == null || !config.containsKey(key)) {
            return value;
        }
        CaseCanonicalizationMode canonicalizationMode = config.get(key);
        if (canonicalizationMode == null) {
            canonicalizationMode = this.defaultCaseCanonicalizationMode;
        }
        ArrayList<Object> canonicalizedValues = new ArrayList<Object>(value.size());
        for (Object origValue : value) {
            if (origValue instanceof String) {
                String stringValue = (String)origValue;
                canonicalizedValues.add(canonicalizationMode.canonicalize(stringValue, Locale.ENGLISH));
                continue;
            }
            canonicalizedValues.add(origValue);
        }
        return canonicalizedValues;
    }

    protected String getConfiguredUserNameAttribute() {
        if (this.unmappedUsernameAttribute != null) {
            return this.unmappedUsernameAttribute;
        }
        UsernameAttributeProvider usernameAttributeProvider = this.getUsernameAttributeProvider();
        return usernameAttributeProvider.getUsernameAttribute();
    }

    protected boolean isUserNameAttributeConfigured() {
        return this.unmappedUsernameAttribute != null;
    }

    public void setQueryAttributeMapping(Map<String, ?> queryAttributeMapping) {
        this.queryAttributeMapping = AbstractQueryPersonAttributeDao.parseAttributeToAttributeMapping(queryAttributeMapping);
    }

    public Set<String> getPossibleUserAttributeNames(PersonAttributeDaoFilter filter) {
        return Set.copyOf(this.possibleUserAttributeNames);
    }

    @Generated
    public Map<String, Set<String>> getQueryAttributeMapping() {
        return this.queryAttributeMapping;
    }

    @Generated
    public Map<String, Set<String>> getResultAttributeMapping() {
        return this.resultAttributeMapping;
    }

    @Generated
    public Map<String, CaseCanonicalizationMode> getCaseInsensitiveResultAttributes() {
        return this.caseInsensitiveResultAttributes;
    }

    @Generated
    public void setCaseInsensitiveResultAttributes(Map<String, CaseCanonicalizationMode> caseInsensitiveResultAttributes) {
        this.caseInsensitiveResultAttributes = caseInsensitiveResultAttributes;
    }

    @Generated
    public Map<String, CaseCanonicalizationMode> getCaseInsensitiveQueryAttributes() {
        return this.caseInsensitiveQueryAttributes;
    }

    @Generated
    public void setCaseInsensitiveQueryAttributes(Map<String, CaseCanonicalizationMode> caseInsensitiveQueryAttributes) {
        this.caseInsensitiveQueryAttributes = caseInsensitiveQueryAttributes;
    }

    @Generated
    public CaseCanonicalizationMode getDefaultCaseCanonicalizationMode() {
        return this.defaultCaseCanonicalizationMode;
    }

    @Generated
    public void setDefaultCaseCanonicalizationMode(CaseCanonicalizationMode defaultCaseCanonicalizationMode) {
        this.defaultCaseCanonicalizationMode = defaultCaseCanonicalizationMode;
    }

    @Generated
    public CaseCanonicalizationMode getUsernameCaseCanonicalizationMode() {
        return this.usernameCaseCanonicalizationMode;
    }

    @Generated
    public void setUsernameCaseCanonicalizationMode(CaseCanonicalizationMode usernameCaseCanonicalizationMode) {
        this.usernameCaseCanonicalizationMode = usernameCaseCanonicalizationMode;
    }

    @Generated
    public boolean isRequireAllQueryAttributes() {
        return this.requireAllQueryAttributes;
    }

    @Generated
    public void setRequireAllQueryAttributes(boolean requireAllQueryAttributes) {
        this.requireAllQueryAttributes = requireAllQueryAttributes;
    }

    @Generated
    public boolean isUseAllQueryAttributes() {
        return this.useAllQueryAttributes;
    }

    @Generated
    public void setUseAllQueryAttributes(boolean useAllQueryAttributes) {
        this.useAllQueryAttributes = useAllQueryAttributes;
    }

    @Generated
    public String getUnmappedUsernameAttribute() {
        return this.unmappedUsernameAttribute;
    }

    @Generated
    public void setUnmappedUsernameAttribute(String unmappedUsernameAttribute) {
        this.unmappedUsernameAttribute = unmappedUsernameAttribute;
    }
}

