/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.api.IntegrationTestHarness;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.util.ShutdownableThread;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005=g\u0001B\u000f\u001f\u0001\rBQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\bi\u0001\u0011\r\u0011\"\u0003-\u0011\u0019)\u0004\u0001)A\u0005[!9a\u0007\u0001b\u0001\n\u0013a\u0003BB\u001c\u0001A\u0003%Q\u0006C\u00049\u0001\t\u0007I\u0011\u0002\u0017\t\re\u0002\u0001\u0015!\u0003.\u0011\u001dQ\u0004A1A\u0005\nmBa\u0001\u0012\u0001!\u0002\u0013a\u0004bB#\u0001\u0005\u0004%Ia\u000f\u0005\u0007\r\u0002\u0001\u000b\u0011\u0002\u001f\t\u000f\u001d\u0003!\u0019!C\u0001\u0011\"1q\n\u0001Q\u0001\n%CQ\u0001\u0015\u0001\u0005BECQ\u0001\u0019\u0001\u0005R1BQ!\u0019\u0001\u0005\u0002\tDq!!\u0007\u0001\t\u0003\tY\u0002C\u0004\u0002&\u0001!I!a\n\t\u000f\u0005\u0005\u0004\u0001\"\u0003\u0002d!9\u0011\u0011\u000e\u0001\u0005\n\u0005-\u0004\"CAI\u0001E\u0005I\u0011BAJ\u0011\u001d\tI\u000b\u0001C\u0005\u0003W3a!a-\u0001\t\u0005U\u0006B\u0002\u0015\u001a\t\u0003\t\u0019\rC\u0004\u0002Jf!\t%a3\t\u000f\u00055\u0017\u0004\"\u0011\u0002L\n1BK]1og\u0006\u001cG/[8og\n{WO\\2f)\u0016\u001cHO\u0003\u0002 A\u0005\u0019\u0011\r]5\u000b\u0003\u0005\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001IA\u0011QEJ\u0007\u0002=%\u0011qE\b\u0002\u0017\u0013:$Xm\u001a:bi&|g\u000eV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012A\u000b\t\u0003K\u0001\tAcY8ogVlWMU3d_J$G+[7f_V$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\u0007%sG/A\u000bd_:\u001cX/\\3SK\u000e|'\u000f\u001a+j[\u0016|W\u000f\u001e\u0011\u0002%A\u0014x\u000eZ;dKJ\u0014UO\u001a4feNK'0Z\u0001\u0014aJ|G-^2fe\n+hMZ3s'&TX\rI\u0001\u0016g\u0016\u0014h/\u001a:NKN\u001c\u0018mZ3NCb\u0014\u0015\u0010^3t\u0003Y\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\u0004\u0013!\u00048v[B\u000b'\u000f^5uS>t7/\u0001\bok6\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002\u0017=,H\u000f];u)>\u0004\u0018nY\u000b\u0002yA\u0011QHQ\u0007\u0002})\u0011q\bQ\u0001\u0005Y\u0006twMC\u0001B\u0003\u0011Q\u0017M^1\n\u0005\rs$AB*ue&tw-\u0001\u0007pkR\u0004X\u000f\u001e+pa&\u001c\u0007%\u0001\u0006j]B,H\u000fV8qS\u000e\f1\"\u001b8qkR$v\u000e]5dA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001J!\tQU*D\u0001L\u0015\ta\u0005)\u0001\u0003vi&d\u0017B\u0001(L\u0005)\u0001&o\u001c9feRLWm]\u0001\u0011_Z,'O]5eS:<\u0007K]8qg\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002%B\u00191\u000b\u0017.\u000e\u0003QS!!\u0016,\u0002\u0013%lW.\u001e;bE2,'BA,0\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00033R\u00131aU3r!\tYf,D\u0001]\u0015\ti\u0006%\u0001\u0004tKJ4XM]\u0005\u0003?r\u00131bS1gW\u0006\u001cuN\u001c4jO\u0006Y!M]8lKJ\u001cu.\u001e8u\u0003=!Xm\u001d;XSRDwI]8va&#GCA2g!\tqC-\u0003\u0002f_\t!QK\\5u\u0011\u00159'\u00031\u0001i\u0003\u0019\tXo\u001c:v[B\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a[\u0018\u000e\u00031T!!\u001c\u0012\u0002\rq\u0012xn\u001c;?\u0013\tyw&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007FT!a\\\u0018)\u0005I\u0019\bC\u0001;~\u001b\u0005)(B\u0001<x\u0003\u0019\u0001\u0018M]1ng*\u0011\u00010_\u0001\bUV\u0004\u0018\u000e^3s\u0015\tQ80A\u0003kk:LGOC\u0001}\u0003\ry'oZ\u0005\u0003}V\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:uQ\u001d\u0011\u0012\u0011AA\u0007\u0003\u001f\u0001B!a\u0001\u0002\n5\u0011\u0011Q\u0001\u0006\u0004\u0003\u000f)\u0018\u0001\u00039s_ZLG-\u001a:\n\t\u0005-\u0011Q\u0001\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005E\u0011QC\u0011\u0003\u0003'\t!A_6\"\u0005\u0005]\u0011!B6sC\u001a$\u0018!\u0006;fgR<\u0016\u000e\u001e5He>,\b/T3uC\u0012\fG/\u0019\u000b\u0004G\u0006u\u0001\"B4\u0014\u0001\u0004A\u0007FA\ntQ\u001d\u0019\u0012\u0011AA\u0007\u0003GaC!!\u0005\u0002\u0016\u0005\tB/Z:u\u0005J|7.\u001a:GC&dWO]3\u0015\u0007\r\fI\u0003C\u0004\u0002,Q\u0001\r!!\f\u0002\r\r|W.\\5u!%q\u0013qFA\u001aQ\u0006U3-C\u0002\u00022=\u0012\u0011BR;oGRLwN\\\u001a\u0011\u0011\u0005U\u0012QIA%\u0003\u0013j!!a\u000e\u000b\t\u0005e\u00121H\u0001\taJ|G-^2fe*!\u0011QHA \u0003\u001d\u0019G.[3oiNT1!IA!\u0015\r\t\u0019e_\u0001\u0007CB\f7\r[3\n\t\u0005\u001d\u0013q\u0007\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0011\u000b9\nY%a\u0014\n\u0007\u00055sFA\u0003BeJ\f\u0017\u0010E\u0002/\u0003#J1!a\u00150\u0005\u0011\u0011\u0015\u0010^3\u0011\u0011\u0005]\u0013QLA%\u0003\u0013j!!!\u0017\u000b\t\u0005m\u00131H\u0001\tG>t7/^7fe&!\u0011qLA-\u0005!\u0019uN\\:v[\u0016\u0014\u0018aG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d\u0007K]8ek\u000e,'\u000f\u0006\u0003\u00024\u0005\u0015\u0004BBA4+\u0001\u0007\u0001.A\bue\u0006t7/Y2uS>t\u0017\r\\%e\u0003i\u0019'/Z1uK\u000e{gn];nKJ\fe\u000eZ*vEN\u001c'/\u001b2f)!\t)&!\u001c\u0002r\u0005\u001d\u0005BBA8-\u0001\u0007\u0001.A\u0004he>,\b/\u00133\t\u000f\u0005Md\u00031\u0001\u0002v\u00051Ao\u001c9jGN\u0004R!a\u001e\u0002\u0002\"tA!!\u001f\u0002~9\u00191.a\u001f\n\u0003AJ1!a 0\u0003\u001d\u0001\u0018mY6bO\u0016LA!a!\u0002\u0006\n!A*[:u\u0015\r\tyh\f\u0005\n\u0003\u00133\u0002\u0013!a\u0001\u0003\u0017\u000bQB]3bI\u000e{W.\\5ui\u0016$\u0007c\u0001\u0018\u0002\u000e&\u0019\u0011qR\u0018\u0003\u000f\t{w\u000e\\3b]\u0006!3M]3bi\u0016\u001cuN\\:v[\u0016\u0014\u0018I\u001c3Tk\n\u001c8M]5cK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002\u0016*\"\u00111RALW\t\tI\n\u0005\u0003\u0002\u001c\u0006\u0015VBAAO\u0015\u0011\ty*!)\u0002\u0013Ut7\r[3dW\u0016$'bAAR_\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0016Q\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D2sK\u0006$X\rV8qS\u000e\u001cHCAAW!\u0015\u0019\u0016qV\u0017.\u0013\r\t\t\f\u0016\u0002\u0004\u001b\u0006\u0004(a\u0004\"pk:\u001cWmU2iK\u0012,H.\u001a:\u0014\u0007e\t9\f\u0005\u0003\u0002:\u0006}VBAA^\u0015\ra\u0015Q\u0018\u0006\u0004;\u0006}\u0012\u0002BAa\u0003w\u0013!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bIR\u0011\u0011Q\u0019\t\u0004\u0003\u000fLR\"\u0001\u0001\u0002\r\u0011|wk\u001c:l)\u0005\u0019\u0017\u0001C:ikR$wn\u001e8")
public class TransactionsBounceTest
extends IntegrationTestHarness {
    private final int consumeRecordTimeout;
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int consumeRecordTimeout() {
        return this.consumeRecordTimeout;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public scala.collection.immutable.Seq<KafkaConfig> generateConfigs() {
        return (scala.collection.immutable.Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnectOrNull(), true, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Override
    public int brokerCount() {
        return 4;
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWithGroupId(String quorum) {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, this.brokers());
        Consumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumerGroup);
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        Consumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable)record -> {
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            return (ListBuffer)((Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer())).append((Object)BoxesRunTime.boxToInteger((int)value));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assertions.assertEquals((Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$), (String)"Out of order messages detected");
            return (ListBuffer)testBrokerFailure_outputRecords.appendAll((IterableOnce)partitionValues);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assertions.assertEquals((int)testBrokerFailure_numInputRecords, (int)testBrokerFailure_recordSet.size());
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), testBrokerFailure_numInputRecords).toSet();
        Assertions.assertEquals((Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((IterableOnce)testBrokerFailure_recordSet)).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testWithGroupMetadata(String quorum) {
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, this.brokers());
        Consumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribe(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = this.createTransactionalProducer("test-txn");
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        try {
            IntRef testBrokerFailure_numMessagesProcessed = IntRef.create((int)0);
            IntRef testBrokerFailure_iteration = IntRef.create((int)0);
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumer.groupMetadata());
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.size();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_scheduler.shutdown();
        }
        Consumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable)record -> {
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            return (ListBuffer)((Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer())).append((Object)BoxesRunTime.boxToInteger((int)value));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assertions.assertEquals((Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$), (String)"Out of order messages detected");
            return (ListBuffer)testBrokerFailure_outputRecords.appendAll((IterableOnce)partitionValues);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assertions.assertEquals((int)testBrokerFailure_numInputRecords, (int)testBrokerFailure_recordSet.size());
        Set testBrokerFailure_expectedValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), testBrokerFailure_numInputRecords).toSet();
        Assertions.assertEquals((Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.$minus$minus((IterableOnce)testBrokerFailure_recordSet)).toString());
    }

    private void testBrokerFailure(Function3<KafkaProducer<byte[], byte[]>, String, Consumer<byte[], byte[]>, BoxedUnit> commit) {
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, this.brokers());
        Consumer<byte[], byte[]> consumer = this.createConsumerAndSubscribe(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> producer = this.createTransactionalProducer("test-txn");
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        try {
            IntRef numMessagesProcessed = IntRef.create((int)0);
            IntRef iteration = IntRef.create((int)0);
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, this.consumeRecordTimeout());
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Received ").append(testBrokerFailure_records.size()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString());
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.size()).append(" messages. Committing offsets.").toString());
                commit.apply(producer, (Object)consumerGroup, consumer);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.size()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.size();
                }
                ++iteration.elem;
            }
        }
        finally {
            scheduler.shutdown();
        }
        Consumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribe("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, this.consumeRecordTimeout()).foreach((Function1 & Serializable)record -> {
            int value = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record)));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            return (ListBuffer)((Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer())).append((Object)BoxesRunTime.boxToInteger((int)value));
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable)partitionValues -> {
            Assertions.assertEquals((Object)partitionValues, (Object)partitionValues.sorted((Ordering)Ordering.Int$.MODULE$), (String)"Out of order messages detected");
            return (ListBuffer)testBrokerFailure_outputRecords.appendAll((IterableOnce)partitionValues);
        });
        Set recordSet = outputRecords.toSet();
        Assertions.assertEquals((int)numInputRecords, (int)recordSet.size());
        Set expectedValues = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numInputRecords).toSet();
        Assertions.assertEquals((Object)expectedValues, (Object)recordSet, (String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.$minus$minus((IterableOnce)recordSet)).toString());
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer(String transactionalId) {
        Properties props = new Properties();
        props.put("acks", "all");
        props.put("batch.size", "512");
        props.put("transactional.id", transactionalId);
        props.put("enable.idempotence", "true");
        ByteArraySerializer x$2 = this.createProducer$default$1();
        ByteArraySerializer x$3 = this.createProducer$default$2();
        return this.createProducer(x$2, x$3, props);
    }

    private Consumer<byte[], byte[]> createConsumerAndSubscribe(String groupId, List<String> topics, boolean readCommitted) {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", groupId);
        consumerProps.put("enable.auto.commit", "false");
        consumerProps.put("isolation.level", readCommitted ? "read_committed" : "read_uncommitted");
        ByteArrayDeserializer x$2 = this.createConsumer$default$1();
        ByteArrayDeserializer x$3 = this.createConsumer$default$2();
        List<String> x$4 = this.createConsumer$default$4();
        Consumer consumer = this.createConsumer(x$2, x$3, consumerProps, x$4);
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribe$default$3() {
        return false;
    }

    private Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig, this.createTopic$default$5(), this.createTopic$default$6());
    }

    public TransactionsBounceTest() {
        this.consumeRecordTimeout = 30000;
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put("auto.create.topics.enable", Boolean.toString(false));
        this.overridingProps().put("message.max.bytes", Integer.toString(this.serverMessageMaxBytes()));
        this.overridingProps().put("controlled.shutdown.enable", Boolean.toString(true));
        this.overridingProps().put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, Boolean.toString(false));
        this.overridingProps().put("auto.leader.rebalance.enable", Boolean.toString(false));
        this.overridingProps().put("offsets.topic.num.partitions", Integer.toString(1));
        this.overridingProps().put("offsets.topic.replication.factor", Integer.toString(3));
        this.overridingProps().put(ServerLogConfigs.MIN_IN_SYNC_REPLICAS_CONFIG, Integer.toString(2));
        this.overridingProps().put("group.min.session.timeout.ms", "10");
        this.overridingProps().put("group.initial.rebalance.delay.ms", "0");
        this.overridingProps().put("transaction.state.log.num.partitions", Integer.toString(1));
        this.overridingProps().put("transaction.state.log.replication.factor", Integer.toString(3));
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupId$1$adapted(KafkaProducer producer, String groupId, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupMetadata$1$adapted(KafkaProducer producer, String x$2, Consumer consumer) {
        producer.sendOffsetsToTransaction(CollectionConverters$.MODULE$.MapHasAsJava(TestUtils$.MODULE$.consumerPositions((Consumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    private class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().brokers().foreach((Function1 & Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions()).foreach((Function1)(JFunction1.mcII.sp & Serializable)partition -> TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChangedWithAdmin(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient$default$1(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().createAdminClient$default$2()), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), partition, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$));
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaBroker server) {
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Shutting down server : %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Server %s shut down. Starting it up again."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            server.startup();
            $this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().trace((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Restarted server: %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)server.config().brokerId())})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

