/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.device.MultifactorAuthenticationRegisteredDevice;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.web.flow.configurer.CasMultifactorWebflowCustomizer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.webflow.execution.RequestContext;

public final class MultifactorAuthenticationWebflowUtils {
    public static List<CasMultifactorWebflowCustomizer> getMultifactorAuthenticationWebflowCustomizers(ConfigurableApplicationContext applicationContext) {
        return applicationContext.getBeansOfType(CasMultifactorWebflowCustomizer.class).values().stream().filter(BeanSupplier::isNotProxy).sorted((Comparator<CasMultifactorWebflowCustomizer>)AnnotationAwareOrderComparator.INSTANCE).collect(Collectors.toList());
    }

    public static boolean isMultifactorDeviceRegistrationEnabled(RequestContext requestContext) {
        Boolean enabled = Objects.requireNonNullElse(requestContext.getFlowScope().getBoolean("mfaDeviceRegistrationEnabled", Boolean.TRUE), Boolean.TRUE);
        return BooleanUtils.toBoolean((Boolean)enabled);
    }

    public static void putMultifactorDeviceRegistrationEnabled(RequestContext requestContext, boolean enabled) {
        requestContext.getFlowScope().put("mfaDeviceRegistrationEnabled", (Object)enabled);
    }

    public static void putResolvedMultifactorAuthenticationProviders(RequestContext context, Collection<MultifactorAuthenticationProvider> value) {
        Set providerIds = value.stream().map(MultifactorAuthenticationProvider::getId).collect(Collectors.toSet());
        context.getConversationScope().put("resolvedMultifactorAuthenticationProviders", providerIds);
    }

    public static Collection<String> getResolvedMultifactorAuthenticationProviders(RequestContext context) {
        return (Collection)context.getConversationScope().get("resolvedMultifactorAuthenticationProviders", Collection.class);
    }

    public static void putMultifactorAuthenticationProvider(RequestContext context, MultifactorAuthenticationProvider provider) {
        context.getFlowScope().put("mfaProviderId", (Object)provider.getId());
    }

    public static String getMultifactorAuthenticationProvider(RequestContext context) {
        return (String)context.getFlowScope().get("mfaProviderId", String.class);
    }

    public static void putSelectableMultifactorAuthenticationProviders(RequestContext requestContext, List<String> mfaProviders) {
        requestContext.getViewScope().put("mfaSelectableProviders", mfaProviders);
    }

    public static List<String> getSelectableMultifactorAuthenticationProviders(RequestContext requestContext) {
        return (List)requestContext.getViewScope().get("mfaSelectableProviders", List.class);
    }

    public static void putGoogleAuthenticatorMultipleDeviceRegistrationEnabled(RequestContext requestContext, boolean enabled) {
        requestContext.getFlowScope().put("gauthMultipleDeviceRegistrationEnabled", (Object)enabled);
    }

    public static Boolean isGoogleAuthenticatorMultipleDeviceRegistrationEnabled(RequestContext requestContext) {
        return (Boolean)requestContext.getFlowScope().get("gauthMultipleDeviceRegistrationEnabled", Boolean.class);
    }

    public static void putYubiKeyMultipleDeviceRegistrationEnabled(RequestContext requestContext, boolean enabled) {
        requestContext.getFlowScope().put("yubikeyMultipleDeviceRegistrationEnabled", (Object)enabled);
    }

    public static void putSimpleMultifactorAuthenticationToken(RequestContext requestContext, Ticket token) {
        requestContext.getFlowScope().put("simpleMultifactorAuthenticationToken", (Object)token);
    }

    public static void removeSimpleMultifactorAuthenticationToken(RequestContext requestContext) {
        requestContext.getFlowScope().remove("simpleMultifactorAuthenticationToken");
    }

    public static <T extends Ticket> T getSimpleMultifactorAuthenticationToken(RequestContext requestContext, Class<T> clazz) {
        return (T)((Ticket)requestContext.getFlowScope().get("simpleMultifactorAuthenticationToken", clazz));
    }

    public static Credential getMultifactorAuthenticationParentCredential(RequestContext requestContext) {
        return (Credential)requestContext.getFlowScope().get("parentCredential", Credential.class);
    }

    public static void putMultifactorAuthenticationRegisteredDevices(RequestContext requestContext, Set accounts) {
        Set items = (Set)ObjectUtils.defaultIfNull(MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationRegisteredDevices(requestContext), new HashSet());
        items.addAll(accounts);
        requestContext.getFlowScope().put("multifactorRegisteredAccounts", (Object)items);
    }

    public static Set<MultifactorAuthenticationRegisteredDevice> getMultifactorAuthenticationRegisteredDevices(RequestContext requestContext) {
        return (Set)requestContext.getFlowScope().get("multifactorRegisteredAccounts", Set.class);
    }

    public static void putOneTimeTokenAccount(RequestContext requestContext, OneTimeTokenAccount account) {
        requestContext.getFlowScope().put("registeredDevice", (Object)account);
    }

    public static void putOneTimeTokenAccounts(RequestContext requestContext, Collection accounts) {
        requestContext.getFlowScope().put("registeredDevices", (Object)accounts);
    }

    public static Collection getOneTimeTokenAccounts(RequestContext requestContext) {
        return (Collection)requestContext.getFlowScope().get("registeredDevices", Collection.class);
    }

    public static <T extends OneTimeTokenAccount> T getOneTimeTokenAccount(RequestContext requestContext, Class<T> clazz) {
        return (T)((OneTimeTokenAccount)requestContext.getFlowScope().get("registeredDevice", clazz));
    }

    @Generated
    private MultifactorAuthenticationWebflowUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

