/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlUberspect;

public class FqcnResolver
implements JexlUberspect.ClassConstantResolver {
    private final JexlUberspect uberspect;
    private final Set<String> imports = Collections.synchronizedSet(new LinkedHashSet());
    private final Map<String, String> fqcns = new ConcurrentHashMap<String, String>();
    private final FqcnResolver parent;

    FqcnResolver(FqcnResolver solver) {
        this.parent = Objects.requireNonNull(solver, "solver");
        this.uberspect = solver.uberspect;
    }

    FqcnResolver(JexlUberspect uber, Iterable<String> packages) {
        this.uberspect = Objects.requireNonNull(uber, "uberspect");
        this.parent = null;
        this.importCheck(packages);
    }

    String getQualifiedName(String name) {
        String fqcn;
        if (this.parent != null && (fqcn = this.parent.getQualifiedName(name)) != null) {
            return fqcn;
        }
        return this.fqcns.computeIfAbsent(name, this::solveClassName);
    }

    private String solveClassName(String name) {
        for (String pkg : this.imports) {
            for (char dot : new char[]{'.', '$'}) {
                Class<?> clazz = this.uberspect.getClassByName(pkg + dot + name);
                if (clazz == null) continue;
                return clazz.getName();
            }
        }
        return null;
    }

    private void importCheck(Iterable<String> names) {
        if (names != null) {
            names.forEach(this::importCheck);
        }
    }

    private void importCheck(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        Package pkg = Package.getPackage(name);
        if (pkg == null) {
            Class<?> clazz = this.uberspect.getClassByName(name);
            if (clazz == null) {
                throw new JexlException(null, "Cannot import '" + name + "' as it is neither a package nor a class");
            }
            this.fqcns.put(name, clazz.getName());
        }
        this.imports.add(name);
    }

    FqcnResolver importPackages(Iterable<String> packages) {
        if (packages != null) {
            if (this.parent == null) {
                this.importCheck(packages);
            } else {
                packages.forEach(pkg -> {
                    if (!this.parent.isImporting((String)pkg)) {
                        this.importCheck((String)pkg);
                    }
                });
            }
        }
        return this;
    }

    boolean isImporting(String pkg) {
        if (this.parent != null && this.parent.isImporting(pkg)) {
            return true;
        }
        return this.imports.contains(pkg);
    }

    @Override
    public String resolveClassName(String name) {
        return this.getQualifiedName(name);
    }

    @Override
    public Object resolveConstant(String cname) {
        return this.getConstant(cname.split("\\."));
    }

    private Object getConstant(String ... ids) {
        if (ids.length == 1) {
            String pname = ids[0];
            for (String cname : this.fqcns.keySet()) {
                Object constant = this.getConstant(cname, pname);
                if (constant == JexlEngine.TRY_FAILED) continue;
                return constant;
            }
        } else if (ids.length == 2) {
            JexlPropertyGet getter;
            Class<?> clazz;
            String cname = ids[0];
            String id = ids[1];
            String fqcn = this.resolveClassName(cname);
            if (fqcn != null && (clazz = this.uberspect.getClassByName(fqcn)) != null && (getter = this.uberspect.getPropertyGet(clazz, id)) != null && getter.isConstant()) {
                try {
                    return getter.invoke(clazz);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return JexlEngine.TRY_FAILED;
    }
}

