/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.scheduling;

import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.actuate.autoconfigure.observation.ObservationAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@AutoConfiguration(after={ObservationAutoConfiguration.class})
@ConditionalOnBean(value={ObservationRegistry.class})
@ConditionalOnClass(value={ThreadPoolTaskScheduler.class})
public class ScheduledTasksObservabilityAutoConfiguration {
    @Bean
    ObservabilitySchedulingConfigurer observabilitySchedulingConfigurer(ObservationRegistry observationRegistry) {
        return new ObservabilitySchedulingConfigurer(observationRegistry);
    }

    static final class ObservabilitySchedulingConfigurer
    implements SchedulingConfigurer {
        private final ObservationRegistry observationRegistry;

        ObservabilitySchedulingConfigurer(ObservationRegistry observationRegistry) {
            this.observationRegistry = observationRegistry;
        }

        public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
            taskRegistrar.setObservationRegistry(this.observationRegistry);
        }
    }
}

