/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.logic;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.policy.PolicyTO;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.syncope.core.logic.AbstractTransactionalLogic;
import org.apache.syncope.core.logic.UnresolvedReferenceException;
import org.apache.syncope.core.persistence.api.dao.NotFoundException;
import org.apache.syncope.core.persistence.api.dao.PolicyDAO;
import org.apache.syncope.core.persistence.api.entity.policy.Policy;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtils;
import org.apache.syncope.core.persistence.api.entity.policy.PolicyUtilsFactory;
import org.apache.syncope.core.provisioning.api.data.PolicyDataBinder;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

public class PolicyLogic
extends AbstractTransactionalLogic<PolicyTO> {
    protected final PolicyDAO policyDAO;
    protected final PolicyDataBinder binder;
    protected final PolicyUtilsFactory policyUtilsFactory;

    public PolicyLogic(PolicyDAO policyDAO, PolicyDataBinder binder, PolicyUtilsFactory policyUtilsFactory) {
        this.policyDAO = policyDAO;
        this.binder = binder;
        this.policyUtilsFactory = policyUtilsFactory;
    }

    @PreAuthorize(value="hasRole('POLICY_CREATE')")
    public <T extends PolicyTO> T create(PolicyType type, T policyTO) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(policyTO);
        if (policyUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(policyUtils.getType()));
            throw sce;
        }
        return (T)this.binder.getPolicyTO(this.policyDAO.save(this.binder.create(policyTO)));
    }

    @PreAuthorize(value="hasRole('POLICY_UPDATE')")
    public PolicyTO update(PolicyType type, PolicyTO policyTO) {
        Policy policy = Optional.ofNullable(this.policyDAO.find(policyTO.getKey())).orElseThrow(() -> new NotFoundException("Policy " + policyTO.getKey() + " not found"));
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(policy);
        if (policyUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(policyUtils.getType()));
            throw sce;
        }
        return this.binder.getPolicyTO(this.policyDAO.save(this.binder.update(policy, policyTO)));
    }

    @PreAuthorize(value="hasRole('POLICY_LIST')")
    @Transactional(readOnly=true)
    public <T extends PolicyTO> List<T> list(PolicyType type) {
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(type);
        return this.policyDAO.find(policyUtils.policyClass()).stream().map(arg_0 -> ((PolicyDataBinder)this.binder).getPolicyTO(arg_0)).collect(Collectors.toList());
    }

    @PreAuthorize(value="hasRole('POLICY_READ')")
    @Transactional(readOnly=true)
    public <T extends PolicyTO> T read(PolicyType type, String key) {
        Policy policy = Optional.ofNullable(this.policyDAO.find(key)).orElseThrow(() -> new NotFoundException("Policy " + key + " not found"));
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(policy);
        if (type != null && policyUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(policyUtils.getType()));
            throw sce;
        }
        return (T)this.binder.getPolicyTO(policy);
    }

    @PreAuthorize(value="hasRole('POLICY_DELETE')")
    public <T extends PolicyTO> T delete(PolicyType type, String key) {
        Policy policy = Optional.ofNullable(this.policyDAO.find(key)).orElseThrow(() -> new NotFoundException("Policy " + key + " not found"));
        PolicyUtils policyUtils = this.policyUtilsFactory.getInstance(policy);
        if (type != null && policyUtils.getType() != type) {
            SyncopeClientException sce = SyncopeClientException.build((ClientExceptionType)ClientExceptionType.InvalidRequest);
            sce.getElements().add("Found " + String.valueOf(type) + ", expected " + String.valueOf(policyUtils.getType()));
            throw sce;
        }
        PolicyTO deleted = this.binder.getPolicyTO(policy);
        this.policyDAO.delete(policy);
        return (T)deleted;
    }

    @Override
    protected PolicyTO resolveReference(Method method, Object ... args) throws UnresolvedReferenceException {
        if (ArrayUtils.isEmpty((Object[])args) || args.length != 2) {
            throw new UnresolvedReferenceException();
        }
        try {
            String key;
            if (!(args[0] instanceof PolicyType)) {
                throw new RuntimeException("Invalid Policy type");
            }
            PolicyType type = (PolicyType)args[0];
            if (args[1] instanceof String) {
                key = (String)args[1];
            } else if (args[1] instanceof PolicyTO) {
                key = ((PolicyTO)args[1]).getKey();
            } else {
                throw new RuntimeException("Invalid ClientApp key");
            }
            return this.read(type, key);
        }
        catch (Throwable t) {
            throw new UnresolvedReferenceException();
        }
    }
}

