/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.resizable;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.interaction.resizable.IResizableListener;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.attributes.CallbackParameter;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.util.lang.Args;

public class ResizableBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "resizable";
    private final IResizableListener listener;
    private JQueryAjaxBehavior onResizeStartAjaxBehavior = null;
    private JQueryAjaxBehavior onResizeStopAjaxBehavior = null;

    public ResizableBehavior(String selector, IResizableListener listener) {
        this(selector, new Options(), listener);
    }

    public ResizableBehavior(String selector, Options options, IResizableListener listener) {
        super(selector, METHOD, options);
        this.listener = (IResizableListener)Args.notNull((Object)listener, (String)"listener");
    }

    public void bind(Component component) {
        super.bind(component);
        if (this.listener.isResizeStartEventEnabled()) {
            this.onResizeStartAjaxBehavior = this.newOnResizeStartAjaxBehavior(this);
            component.add(new Behavior[]{this.onResizeStartAjaxBehavior});
        }
        if (this.listener.isResizeStopEventEnabled()) {
            this.onResizeStopAjaxBehavior = this.newOnResizeStopAjaxBehavior(this);
            component.add(new Behavior[]{this.onResizeStopAjaxBehavior});
        }
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onResizeStartAjaxBehavior != null) {
            this.setOption("start", this.onResizeStartAjaxBehavior.getCallbackFunction());
        }
        if (this.onResizeStopAjaxBehavior != null) {
            this.setOption("stop", this.onResizeStopAjaxBehavior.getCallbackFunction());
        }
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ResizeEvent) {
            ResizeEvent ev = (ResizeEvent)event;
            if (ev instanceof ResizeStartEvent) {
                this.listener.onResizeStart(target, ev.getTop(), ev.getLeft(), ev.getWidth(), ev.getHeight());
            }
            if (ev instanceof ResizeStopEvent) {
                this.listener.onResizeStop(target, ev.getTop(), ev.getLeft(), ev.getWidth(), ev.getHeight());
            }
        }
    }

    protected JQueryAjaxBehavior newOnResizeStartAjaxBehavior(IJQueryAjaxAware source) {
        return new OnResizeStartAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnResizeStopAjaxBehavior(IJQueryAjaxAware source) {
        return new OnResizeStopAjaxBehavior(source);
    }

    protected static class ResizeStopEvent
    extends ResizeEvent {
        protected ResizeStopEvent() {
        }
    }

    protected static class ResizeStartEvent
    extends ResizeEvent {
        protected ResizeStartEvent() {
        }
    }

    protected static class ResizeEvent
    extends JQueryEvent {
        private final int top = RequestCycleUtils.getQueryParameterValue((String)"top").toInt(-1);
        private final int left = RequestCycleUtils.getQueryParameterValue((String)"left").toInt(-1);
        private final int width = RequestCycleUtils.getQueryParameterValue((String)"width").toInt(-1);
        private final int height = RequestCycleUtils.getQueryParameterValue((String)"height").toInt(-1);

        public int getTop() {
            return this.top;
        }

        public int getLeft() {
            return this.left;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }

    protected static class OnResizeStopAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnResizeStopAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top"), CallbackParameter.resolved((String)"left", (String)"ui.position.left"), CallbackParameter.resolved((String)"width", (String)"ui.size.width"), CallbackParameter.resolved((String)"height", (String)"ui.size.height")};
        }

        protected JQueryEvent newEvent() {
            return new ResizeStopEvent();
        }
    }

    protected static class OnResizeStartAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnResizeStartAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        protected CallbackParameter[] getCallbackParameters() {
            return new CallbackParameter[]{CallbackParameter.context((String)"event"), CallbackParameter.context((String)"ui"), CallbackParameter.resolved((String)"top", (String)"ui.position.top"), CallbackParameter.resolved((String)"left", (String)"ui.position.left"), CallbackParameter.resolved((String)"width", (String)"ui.size.width"), CallbackParameter.resolved((String)"height", (String)"ui.size.height")};
        }

        protected JQueryEvent newEvent() {
            return new ResizeStartEvent();
        }
    }
}

