/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html;

import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.attributes.AjaxCallListener;
import org.apache.wicket.ajax.attributes.AjaxRequestAttributes;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.AjaxEditableLabel;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;

public class AjaxEditableMultiLineLabel<T>
extends AjaxEditableLabel<T> {
    private static final long serialVersionUID = 1L;
    private int rows = 10;
    private int cols = 40;

    public AjaxEditableMultiLineLabel(String id) {
        super(id);
    }

    public AjaxEditableMultiLineLabel(String id, IModel<T> model) {
        super(id, model);
    }

    protected MultiLineLabel newLabel(MarkupContainer parent, String componentId, IModel<T> model) {
        MultiLineLabel label = new MultiLineLabel(componentId, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                return AjaxEditableMultiLineLabel.this.getConverter(type);
            }

            public void onComponentTagBody(MarkupStream markupStream, ComponentTag openTag) {
                Object modelObject = this.getDefaultModelObject();
                if (modelObject == null || modelObject instanceof String && ((String)modelObject).isEmpty()) {
                    this.replaceComponentTagBody(markupStream, openTag, AjaxEditableMultiLineLabel.this.defaultNullLabel());
                } else {
                    super.onComponentTagBody(markupStream, openTag);
                }
            }
        };
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{new AjaxEditableLabel.LabelAjaxBehavior(this.getLabelAjaxEvent())});
        return label;
    }

    @Override
    protected String getLabelAjaxEvent() {
        return "click";
    }

    @Override
    protected FormComponent<T> newEditor(MarkupContainer parent, String componentId, IModel<T> model) {
        TextArea editor = new TextArea<T>(componentId, model){
            private static final long serialVersionUID = 1L;

            public <C> IConverter<C> getConverter(Class<C> type) {
                return AjaxEditableMultiLineLabel.this.getConverter(type);
            }

            protected boolean shouldTrimInput() {
                return AjaxEditableMultiLineLabel.this.shouldTrimInput();
            }

            protected void onModelChanged() {
                AjaxEditableMultiLineLabel.this.onModelChanged();
            }

            protected void onModelChanging() {
                AjaxEditableMultiLineLabel.this.onModelChanging();
            }
        };
        editor.add(new Behavior[]{new AttributeModifier("rows", (IModel & Serializable)() -> this.rows)});
        editor.add(new Behavior[]{new AttributeModifier("cols", (IModel & Serializable)() -> this.cols)});
        editor.setOutputMarkupId(true);
        editor.setVisible(false);
        editor.add(new Behavior[]{new AjaxEditableLabel.EditorAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateAjaxAttributes(AjaxRequestAttributes attributes) {
                super.updateAjaxAttributes(attributes);
                attributes.setMethod(AjaxRequestAttributes.Method.POST);
                attributes.setEventNames(new String[]{"blur", "keyup"});
                String dynamicExtraParameters = "var result = [], kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type;if (evtType === 'keyup') {if (kc===27) { result.push( { name: 'save', value: false } ); }}else if (evtType==='blur') { result = Wicket.Form.serializeElement(attrs.c); result.push( { name: 'save', value: true } ); }return result;";
                attributes.getDynamicExtraParameters().add(dynamicExtraParameters);
                String precondition = "var kc=Wicket.Event.keyCode(attrs.event),evtType=attrs.event.type,ret=false;if(evtType==='blur' || (evtType==='keyup' && (kc===27))) ret = true;return ret;";
                AjaxCallListener ajaxCallListener = new AjaxCallListener();
                ajaxCallListener.onPrecondition((CharSequence)precondition);
                attributes.getAjaxCallListeners().add(ajaxCallListener);
            }
        }});
        return editor;
    }

    public final int getCols() {
        return this.cols;
    }

    public final void setCols(int cols) {
        this.cols = cols;
    }

    public final int getRows() {
        return this.rows;
    }

    public final void setRows(int rows) {
        this.rows = rows;
    }

    @Override
    protected String defaultNullLabel() {
        return "...";
    }

    @Override
    protected void onModelChanged() {
        super.onModelChanged();
    }

    @Override
    protected void onModelChanging() {
        super.onModelChanging();
    }
}

