/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORUtilities;
import com.upokecenter.cbor.ICBORNumber;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

class CBORDoubleBits
implements ICBORNumber {
    CBORDoubleBits() {
    }

    @Override
    public boolean IsPositiveInfinity(Object obj) {
        return (Long)obj == 0x7FF0000000000000L;
    }

    @Override
    public boolean IsInfinity(Object obj) {
        return ((Long)obj & Long.MAX_VALUE) == 0x7FF0000000000000L;
    }

    @Override
    public boolean IsNegativeInfinity(Object obj) {
        return (Long)obj == -4503599627370496L;
    }

    @Override
    public boolean IsNaN(Object obj) {
        return CBORUtilities.DoubleBitsNaN((Long)obj);
    }

    @Override
    public double AsDouble(Object obj) {
        return CBORUtilities.Int64BitsToDouble((Long)obj);
    }

    @Override
    public EDecimal AsEDecimal(Object obj) {
        return EDecimal.FromDoubleBits((long)((Long)obj));
    }

    @Override
    public EFloat AsEFloat(Object obj) {
        return EFloat.FromDoubleBits((long)((Long)obj));
    }

    @Override
    public float AsSingle(Object obj) {
        return CBORUtilities.Int32BitsToSingle(CBORUtilities.DoubleToRoundedSinglePrecision((Long)obj));
    }

    @Override
    public EInteger AsEInteger(Object obj) {
        return CBORUtilities.EIntegerFromDoubleBits((Long)obj);
    }

    @Override
    public long AsInt64(Object obj) {
        boolean neg;
        if (this.IsNaN(obj) || this.IsInfinity(obj)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        long b = CBORDoubleBits.DoubleBitsRoundDown((Long)obj);
        boolean bl = neg = b >> 63 != 0L;
        if ((b &= Long.MAX_VALUE) == 0L) {
            return 0L;
        }
        if (neg && b == 4890909195324358656L) {
            return Long.MIN_VALUE;
        }
        if (b >> 52 >= 1086L) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        int exp = (int)(b >> 52);
        long mant = b & 0xFFFFFFFFFFFFFL;
        mant |= 0x10000000000000L;
        int shift = 52 - (exp - 1023);
        mant = shift < 0 ? (mant <<= -shift) : (mant >>= shift);
        if (neg) {
            mant = -mant;
        }
        return mant;
    }

    @Override
    public boolean CanFitInSingle(Object obj) {
        return this.IsNaN(obj) || CBORUtilities.DoubleRetainsSameValueInSingle((Long)obj);
    }

    @Override
    public boolean CanFitInDouble(Object obj) {
        return true;
    }

    @Override
    public boolean CanFitInInt32(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt32(obj);
    }

    @Override
    public boolean CanFitInInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInInt64(obj);
    }

    @Override
    public boolean CanFitInUInt64(Object obj) {
        return this.IsIntegral(obj) && this.CanTruncatedIntFitInUInt64(obj);
    }

    private static long DoubleBitsRoundDown(long bits) {
        long origbits = bits;
        if ((bits &= Long.MAX_VALUE) == 0L) {
            return origbits;
        }
        if (bits >= 0x7FF0000000000000L) {
            return origbits;
        }
        if (bits >> 52 >= 1075L) {
            return origbits;
        }
        if (bits >> 52 <= 1022L) {
            return origbits >> 63 != 0L ? Long.MIN_VALUE : 0L;
        }
        int exp = (int)(bits >> 52);
        long mant = bits & 0xFFFFFFFFFFFFFL;
        int shift = 52 - (exp - 1023);
        return mant >> shift << shift | origbits & 0xFFF0000000000000L;
    }

    @Override
    public boolean CanTruncatedIntFitInInt64(Object obj) {
        if (this.IsNaN(obj) || this.IsInfinity(obj)) {
            return false;
        }
        long b = CBORDoubleBits.DoubleBitsRoundDown((Long)obj);
        boolean neg = b >> 63 != 0L;
        return neg && (b &= Long.MAX_VALUE) == 4890909195324358656L || b >> 52 < 1086L;
    }

    @Override
    public boolean CanTruncatedIntFitInUInt64(Object obj) {
        if (this.IsNaN(obj) || this.IsInfinity(obj)) {
            return false;
        }
        long b = CBORDoubleBits.DoubleBitsRoundDown((Long)obj);
        boolean neg = b >> 63 != 0L;
        return neg && (b &= Long.MAX_VALUE) == 0L || !neg && b >> 52 < 1087L;
    }

    @Override
    public boolean CanTruncatedIntFitInInt32(Object obj) {
        if (this.IsNaN(obj) || this.IsInfinity(obj)) {
            return false;
        }
        long b = CBORDoubleBits.DoubleBitsRoundDown((Long)obj);
        boolean neg = b >> 63 != 0L;
        return neg && (b &= Long.MAX_VALUE) == 4746794007248502784L || b >> 52 < 1054L;
    }

    @Override
    public int AsInt32(Object obj, int minValue, int maxValue) {
        boolean neg;
        if (this.IsNaN(obj) || this.IsInfinity(obj)) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        long b = CBORDoubleBits.DoubleBitsRoundDown((Long)obj);
        boolean bl = neg = b >> 63 != 0L;
        if ((b &= Long.MAX_VALUE) == 0L) {
            return 0;
        }
        if (b >> 52 >= 1075L) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        int exp = (int)(b >> 52);
        long mant = b & 0xFFFFFFFFFFFFFL;
        mant |= 0x10000000000000L;
        int shift = 52 - (exp - 1023);
        mant >>= shift;
        if (neg) {
            mant = -mant;
        }
        if (mant < (long)minValue || mant > (long)maxValue) {
            throw new ArithmeticException("This Object's value is out of range");
        }
        return (int)mant;
    }

    @Override
    public boolean IsNumberZero(Object obj) {
        return ((Long)obj & Long.MAX_VALUE) == 0L;
    }

    @Override
    public int Sign(Object obj) {
        return this.IsNaN(obj) ? -2 : ((Long)obj >> 63 != 0L ? -1 : 1);
    }

    @Override
    public boolean IsIntegral(Object obj) {
        return CBORUtilities.IsIntegerValue((Long)obj);
    }

    @Override
    public Object Negate(Object obj) {
        return (Long)obj ^ Long.MIN_VALUE;
    }

    @Override
    public Object Abs(Object obj) {
        return (Long)obj & Long.MAX_VALUE;
    }

    @Override
    public ERational AsERational(Object obj) {
        return ERational.FromDoubleBits((long)((Long)obj));
    }

    @Override
    public boolean IsNegative(Object obj) {
        return (Long)obj >> 63 != 0L;
    }
}

