/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.beans.FeatureDescriptor;
import java.util.Iterator;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.el.EvaluationState;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.common.engine.impl.javax.el.ELContext;
import org.flowable.common.engine.impl.javax.el.ELResolver;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.api.persistence.entity.VariableInstance;

public class VariableContainerELResolver
extends ELResolver {
    public static final String VARIABLE_CONTAINER_KEY = "variableContainer";
    public static final String LOGGED_IN_USER_KEY = "authenticatedUserId";

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            VariableContainer variableContainer = this.getVariableContainer(context);
            if (LOGGED_IN_USER_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return Authentication.getAuthenticatedUserId();
            }
            if (variableContainer.hasVariable(variable)) {
                Object value = null;
                if (context.getContext(EvaluationState.class) == EvaluationState.WRITE) {
                    if (variableContainer instanceof VariableScope) {
                        VariableInstance variableInstance = ((VariableScope)variableContainer).getVariableInstance(variable);
                        if (!variableInstance.isReadOnly()) {
                            value = variableInstance.getValue();
                        }
                    } else {
                        value = variableContainer.getVariable(variable);
                    }
                } else {
                    value = variableContainer.getVariable(variable);
                }
                context.setPropertyResolved(true);
                return value;
            }
            if (VARIABLE_CONTAINER_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return variableContainer;
            }
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base == null) {
            String variable = (String)property;
            return !this.getVariableContainer(context).hasVariable(variable);
        }
        return true;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base == null) {
            String variable = (String)property;
            VariableContainer variableContainer = this.getVariableContainer(context);
            if (variableContainer.hasVariable(variable)) {
                context.setPropertyResolved(true);
                if (variableContainer instanceof VariableScope) {
                    VariableInstance variableInstance = ((VariableScope)variableContainer).getVariableInstance(variable);
                    if (variableInstance == null || !variableInstance.isReadOnly()) {
                        variableContainer.setVariable(variable, value);
                    }
                } else {
                    variableContainer.setVariable(variable, value);
                }
            }
        }
    }

    protected VariableContainer getVariableContainer(ELContext elContext) {
        return (VariableContainer)elContext.getContext(VariableContainer.class);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext arg0, Object arg1) {
        return Object.class;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext arg0, Object arg1) {
        return null;
    }

    @Override
    public Class<?> getType(ELContext arg0, Object arg1, Object arg2) {
        return Object.class;
    }
}

