/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons;

import java.security.AccessControlException;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.xml.ws.WebServiceException;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.ui.commons.BaseLogin;
import org.apache.syncope.client.ui.commons.BaseSession;
import org.apache.syncope.common.lib.SyncopeClientException;
import org.apache.syncope.common.lib.types.ClientExceptionType;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.core.request.handler.IPageProvider;
import org.apache.wicket.core.request.handler.PageProvider;
import org.apache.wicket.core.request.handler.RenderPageRequestHandler;
import org.apache.wicket.markup.html.pages.ExceptionErrorPage;
import org.apache.wicket.protocol.http.PageExpiredException;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyncopeUIRequestCycleListener
implements IRequestCycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SyncopeUIRequestCycleListener.class);

    private static <T extends Exception> Optional<T> instanceOf(Exception e, Class<T> clazz) {
        if (clazz.isAssignableFrom(e.getClass())) {
            return Optional.of(e);
        }
        if (e.getCause() != null && clazz.isAssignableFrom(e.getCause().getClass())) {
            return Optional.of((Exception)e.getCause());
        }
        if (e.getCause() != null && e.getCause().getCause() != null && clazz.isAssignableFrom(e.getCause().getCause().getClass())) {
            return Optional.of((Exception)e.getCause().getCause());
        }
        return Optional.empty();
    }

    public IRequestHandler onException(RequestCycle cycle, Exception e) {
        IRequestablePage errorPage;
        LOG.error("Exception found", (Throwable)e);
        PageParameters errorParameters = new PageParameters();
        if (SyncopeUIRequestCycleListener.instanceOf(e, UnauthorizedInstantiationException.class).isPresent()) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.AUTHORIZATION.message());
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, AccessControlException.class).isPresent()) {
            AccessControlException ace = SyncopeUIRequestCycleListener.instanceOf(e, AccessControlException.class).get();
            if (StringUtils.containsIgnoreCase((CharSequence)ace.getMessage(), (CharSequence)"expired")) {
                errorParameters.add("errorMessage", (Object)BaseSession.Error.SESSION_EXPIRED.message());
            } else {
                errorParameters.add("errorMessage", (Object)BaseSession.Error.AUTHORIZATION.message());
            }
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, SyncopeClientException.class).isPresent()) {
            SyncopeClientException sce = SyncopeUIRequestCycleListener.instanceOf(e, SyncopeClientException.class).get();
            String errorMessage = sce.getType() == ClientExceptionType.Unknown ? sce.getElements().stream().collect(Collectors.joining()) : sce.getMessage();
            errorParameters.add("errorMessage", (Object)errorMessage);
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, BadRequestException.class).isPresent() || SyncopeUIRequestCycleListener.instanceOf(e, WebServiceException.class).isPresent()) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.REST.message());
            errorPage = this.getErrorPage(errorParameters);
        } else if (SyncopeUIRequestCycleListener.instanceOf(e, PageExpiredException.class).isPresent() || !this.isSignedIn()) {
            errorParameters.add("errorMessage", (Object)BaseSession.Error.SESSION_EXPIRED.message());
            errorPage = this.getErrorPage(errorParameters);
        } else {
            Optional<ForbiddenException> cause = SyncopeUIRequestCycleListener.instanceOf(e, ForbiddenException.class);
            if (cause.isPresent()) {
                errorParameters.add("errorMessage", (Object)cause.get().getMessage());
                errorPage = this.getErrorPage(errorParameters);
            } else {
                errorPage = new ExceptionErrorPage((Throwable)e, null);
            }
        }
        if (errorPage instanceof BaseLogin) {
            try {
                this.invalidateSession();
            }
            catch (Throwable t) {
                LOG.debug("Unexpected error while forcing logout after error", t);
            }
        }
        return new RenderPageRequestHandler((IPageProvider)new PageProvider(errorPage));
    }

    protected abstract boolean isSignedIn();

    protected abstract void invalidateSession();

    protected abstract IRequestablePage getErrorPage(PageParameters var1);
}

