/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import io.github.bucket4j.distributed.serialization.InternalSerializationHelper;
import io.github.bucket4j.distributed.versioning.UnsupportedTypeException;
import io.github.bucket4j.distributed.versioning.UsageOfObsoleteApiException;
import io.github.bucket4j.distributed.versioning.UsageOfUnsupportedApiException;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;

public abstract class AbstractBinaryTransaction
implements MutableBucketEntry {
    private final byte[] requestBytes;
    private Version backwardCompatibilityVersion;

    protected AbstractBinaryTransaction(byte[] requestBytes) {
        this.requestBytes = requestBytes;
    }

    public byte[] execute() {
        Request request;
        try {
            request = InternalSerializationHelper.deserializeRequest(this.requestBytes);
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), Versions.getOldest());
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), Versions.getOldest());
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), Versions.getOldest());
        }
        this.backwardCompatibilityVersion = request.getBackwardCompatibilityVersion();
        try {
            long time = request.getClientSideTime() != null ? request.getClientSideTime() : System.currentTimeMillis() * 1000000L;
            RemoteCommand command = request.getCommand();
            CommandResult result = command.execute(this, time);
            return InternalSerializationHelper.serializeResult(result, request.getBackwardCompatibilityVersion());
        }
        catch (UnsupportedTypeException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.unsupportedType(e.getTypeId()), this.backwardCompatibilityVersion);
        }
        catch (UsageOfUnsupportedApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfUnsupportedApiException(e.getRequestedFormatNumber(), e.getMaxSupportedFormatNumber()), this.backwardCompatibilityVersion);
        }
        catch (UsageOfObsoleteApiException e) {
            return InternalSerializationHelper.serializeResult(CommandResult.usageOfObsoleteApiException(e.getRequestedFormatNumber(), e.getMinSupportedFormatNumber()), this.backwardCompatibilityVersion);
        }
    }

    @Override
    public void set(RemoteBucketState state) {
        byte[] stateBytes = InternalSerializationHelper.serializeState(state, this.backwardCompatibilityVersion);
        this.setRawState(stateBytes);
    }

    @Override
    public RemoteBucketState get() {
        byte[] stateBytes = this.getRawState();
        return InternalSerializationHelper.deserializeState(stateBytes);
    }

    protected abstract byte[] getRawState();

    protected abstract void setRawState(byte[] var1);
}

