/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.inputmask;

import com.fasterxml.jackson.annotation.JsonValue;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import de.agilecoders.wicket.jquery.Key;

public class InputMaskConfig
extends AbstractConfig {
    private static final IKey<String> MASK = new Key("mask");
    private static final IKey<String> PLACEHOLDER = new Key("placeholder", (Object)"_");
    private static final IKey<String> REGEX = new Key("regex");
    private static final IKey<Integer> REPEAT = new Key("repeat");
    private static final IKey<Boolean> GREEDY = new Key("greedy", (Object)false);
    private static final IKey<Boolean> AUTO_UNMASK = new Key("autoUnmask", (Object)false);
    private static final IKey<Boolean> REMOVE_MASK_ON_SUBMIT = new Key("removeMaskOnSubmit", (Object)false);
    private static final IKey<Boolean> CLEAR_MASK_ON_LOST_FOCUS = new Key("clearMaskOnLostFocus", (Object)true);
    private static final IKey<Boolean> INSERT_MODE = new Key("insertMode", (Object)true);
    private static final IKey<Boolean> CLEAR_INCOMPLETE = new Key("clearIncomplete");
    private static final IKey<Boolean> SHOW_MASK_ON_FOCUS = new Key("showMaskOnFocus", (Object)true);
    private static final IKey<Boolean> SHOW_MASK_ON_HOVER = new Key("showMaskOnHover", (Object)true);
    private static final IKey<Boolean> NUMERIC_INPUT = new Key("numericInput");
    private static final IKey<Boolean> RIGHT_ALIGN = new Key("rightAlign");
    private static final IKey<Boolean> UNDO_ON_ESCAPE = new Key("undoOnEscape", (Object)true);
    private static final IKey<Boolean> POSITION_CARET_ON_TAB = new Key("positionCaretOnTab", (Object)true);
    private static final IKey<Boolean> TAB_THROUGH = new Key("tabThrough", (Object)false);
    private static final IKey<Boolean> NULLABLE = new Key("nullable", (Object)true);
    private static final IKey<CaretPosition> POSITION_CARET_ON_CLICK = new Key("positionCaretOnClick", (Object)CaretPosition.LVP);

    public InputMaskConfig mask(String mask) {
        this.put(MASK, mask);
        return this;
    }

    public InputMaskConfig placeholder(String placeholder) {
        this.put(PLACEHOLDER, placeholder);
        return this;
    }

    public InputMaskConfig regex(String regex) {
        this.put(REGEX, regex);
        return this;
    }

    public InputMaskConfig repeat(int repeat) {
        this.put(REPEAT, repeat);
        return this;
    }

    public InputMaskConfig greedy(boolean greedy) {
        this.put(GREEDY, greedy);
        return this;
    }

    public InputMaskConfig autoUnmask(boolean autoUnmask) {
        this.put(AUTO_UNMASK, autoUnmask);
        return this;
    }

    public InputMaskConfig removeMaskOnSubmit(boolean removeMaskOnSubmit) {
        this.put(REMOVE_MASK_ON_SUBMIT, removeMaskOnSubmit);
        return this;
    }

    public InputMaskConfig clearMarkOnLostFocus(boolean clearMaskOnFocus) {
        this.put(CLEAR_MASK_ON_LOST_FOCUS, clearMaskOnFocus);
        return this;
    }

    public InputMaskConfig insertMode(boolean insertMode) {
        this.put(INSERT_MODE, insertMode);
        return this;
    }

    public InputMaskConfig clearIncomplete(boolean clearIncomplete) {
        this.put(CLEAR_INCOMPLETE, clearIncomplete);
        return this;
    }

    public InputMaskConfig showMaskOnFocus(boolean showMaskOnFocus) {
        this.put(SHOW_MASK_ON_FOCUS, showMaskOnFocus);
        return this;
    }

    public InputMaskConfig showMaskOnHover(boolean showMaskOnHover) {
        this.put(SHOW_MASK_ON_HOVER, showMaskOnHover);
        return this;
    }

    public InputMaskConfig numericInput(boolean numericInput) {
        this.put(NUMERIC_INPUT, numericInput);
        return this;
    }

    public InputMaskConfig rightAlign(boolean rightAlign) {
        this.put(RIGHT_ALIGN, rightAlign);
        return this;
    }

    public InputMaskConfig undoOnEscape(boolean undoOnEscape) {
        this.put(UNDO_ON_ESCAPE, undoOnEscape);
        return this;
    }

    public InputMaskConfig positionCaretOnTab(boolean positionCaretOnTab) {
        this.put(POSITION_CARET_ON_TAB, positionCaretOnTab);
        return this;
    }

    public InputMaskConfig tabThrough(boolean tabThrough) {
        this.put(TAB_THROUGH, tabThrough);
        return this;
    }

    public InputMaskConfig nullable(boolean nullable) {
        this.put(NULLABLE, nullable);
        return this;
    }

    public InputMaskConfig positionCaretOnClick(CaretPosition position) {
        this.put(POSITION_CARET_ON_CLICK, (Object)position);
        return this;
    }

    public static enum CaretPosition {
        NONE("none"),
        LVP("lvp"),
        RADIX_FOCUS("radixFocus"),
        SELECT("select"),
        IGNORE("ignore");

        private final String value;

        private CaretPosition(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

