/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console;

import com.giffing.wicket.spring.boot.starter.app.WicketBootSecuredWebApplication;
import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.BootstrapSettings;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.core.settings.SingleThemeProvider;
import de.agilecoders.wicket.core.settings.ThemeProvider;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.ConsoleProperties;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.annotations.UserFormFinalize;
import org.apache.syncope.client.console.commons.AccessPolicyConfProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionLinksProvider;
import org.apache.syncope.client.console.commons.AnyDirectoryPanelAdditionalActionsProvider;
import org.apache.syncope.client.console.commons.AnyWizardBuilderAdditionalSteps;
import org.apache.syncope.client.console.commons.ExternalResourceProvider;
import org.apache.syncope.client.console.commons.ImplementationInfoProvider;
import org.apache.syncope.client.console.commons.PolicyTabProvider;
import org.apache.syncope.client.console.commons.RealmsUtils;
import org.apache.syncope.client.console.commons.StatusProvider;
import org.apache.syncope.client.console.commons.VirSchemaDetailsPanelProvider;
import org.apache.syncope.client.console.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.MustChangePassword;
import org.apache.syncope.client.console.rest.RealmRestClient;
import org.apache.syncope.client.console.wizards.any.UserFormFinalizer;
import org.apache.syncope.client.lib.SyncopeAnonymousClient;
import org.apache.syncope.client.lib.SyncopeClientFactoryBean;
import org.apache.syncope.client.ui.commons.SyncopeUIRequestCycleListener;
import org.apache.syncope.client.ui.commons.annotations.Resource;
import org.apache.syncope.client.ui.commons.themes.AdminLTE;
import org.apache.syncope.client.ui.commons.wizards.AjaxWizard;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.rest.api.beans.RealmQuery;
import org.apache.wicket.Application;
import org.apache.wicket.Page;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.authroles.authentication.AbstractAuthenticatedWebSession;
import org.apache.wicket.authroles.authentication.AuthenticatedWebSession;
import org.apache.wicket.authroles.authorization.strategies.role.IRoleCheckingStrategy;
import org.apache.wicket.authroles.authorization.strategies.role.metadata.MetaDataRoleAuthorizationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.servlet.AbstractRequestWrapperFactory;
import org.apache.wicket.protocol.http.servlet.XForwardedRequestWrapperFactory;
import org.apache.wicket.protocol.ws.WebSocketAwareResourceIsolationRequestCycleListener;
import org.apache.wicket.protocol.ws.api.WebSocketResponse;
import org.apache.wicket.request.component.IRequestablePage;
import org.apache.wicket.request.cycle.IRequestCycleListener;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.ResourceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SyncopeWebApplication
extends WicketBootSecuredWebApplication {
    protected static final Logger LOG = LoggerFactory.getLogger(SyncopeWebApplication.class);
    protected final ConsoleProperties props;
    protected final ClassPathScanImplementationLookup lookup;
    protected final ServiceOps serviceOps;
    protected final ExternalResourceProvider resourceProvider;
    protected final AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider;
    protected final AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider;
    protected final AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps;
    protected final StatusProvider statusProvider;
    protected final VirSchemaDetailsPanelProvider virSchemaDetailsPanelProvider;
    protected final ImplementationInfoProvider implementationInfoProvider;
    protected final AccessPolicyConfProvider accessPolicyConfProvider;
    protected final List<PolicyTabProvider> policyTabProviders;
    protected final List<UserFormFinalizer> userFormFinalizers;
    protected final List<IResource> resources;

    public static SyncopeWebApplication get() {
        return (SyncopeWebApplication)WebApplication.get();
    }

    public SyncopeWebApplication(ConsoleProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, ExternalResourceProvider resourceProvider, AnyDirectoryPanelAdditionalActionsProvider anyDirectoryPanelAdditionalActionsProvider, AnyDirectoryPanelAdditionalActionLinksProvider anyDirectoryPanelAdditionalActionLinksProvider, AnyWizardBuilderAdditionalSteps anyWizardBuilderAdditionalSteps, StatusProvider statusProvider, VirSchemaDetailsPanelProvider virSchemaDetailsPanelProvider, ImplementationInfoProvider implementationInfoProvider, AccessPolicyConfProvider accessPolicyConfProvider, List<PolicyTabProvider> policyTabProviders, List<UserFormFinalizer> userFormFinalizers, List<IResource> resources) {
        this.props = props;
        this.lookup = lookup;
        this.serviceOps = serviceOps;
        this.resourceProvider = resourceProvider;
        this.anyDirectoryPanelAdditionalActionsProvider = anyDirectoryPanelAdditionalActionsProvider;
        this.anyDirectoryPanelAdditionalActionLinksProvider = anyDirectoryPanelAdditionalActionLinksProvider;
        this.anyWizardBuilderAdditionalSteps = anyWizardBuilderAdditionalSteps;
        this.statusProvider = statusProvider;
        this.virSchemaDetailsPanelProvider = virSchemaDetailsPanelProvider;
        this.implementationInfoProvider = implementationInfoProvider;
        this.accessPolicyConfProvider = accessPolicyConfProvider;
        this.policyTabProviders = policyTabProviders;
        this.userFormFinalizers = userFormFinalizers;
        this.resources = resources;
    }

    protected SyncopeUIRequestCycleListener buildSyncopeUIRequestCycleListener() {
        return new SyncopeUIRequestCycleListener(){

            protected boolean isSignedIn() {
                return SyncopeConsoleSession.get().isSignedIn();
            }

            protected void invalidateSession() {
                SyncopeConsoleSession.get().invalidate();
            }

            protected IRequestablePage getErrorPage(PageParameters errorParameters) {
                return new Login(errorParameters);
            }
        };
    }

    protected void initSecurity() {
        if (this.props.isxForward()) {
            XForwardedRequestWrapperFactory.Config config = new XForwardedRequestWrapperFactory.Config();
            config.setProtocolHeader(this.props.getxForwardProtocolHeader());
            config.setHttpServerPort(this.props.getxForwardHttpPort());
            config.setHttpsServerPort(this.props.getxForwardHttpsPort());
            XForwardedRequestWrapperFactory factory = new XForwardedRequestWrapperFactory();
            factory.setConfig(config);
            this.getFilterFactoryManager().add((AbstractRequestWrapperFactory)factory);
        }
        if (this.props.isCsrf()) {
            this.getRequestCycleListeners().add((Object)new WebSocketAwareResourceIsolationRequestCycleListener());
        }
        this.getCspSettings().blocking().unsafeInline();
        this.getRequestCycleListeners().add((Object)new IRequestCycleListener(){

            public void onEndRequest(RequestCycle cycle) {
                if (cycle.getResponse() instanceof WebResponse && !(cycle.getResponse() instanceof WebSocketResponse)) {
                    SyncopeWebApplication.this.props.getSecurityHeaders().forEach((name, value) -> ((WebResponse)cycle.getResponse()).setHeader(name, value));
                }
            }
        });
    }

    protected void init() {
        super.init();
        BootstrapSettings settings = new BootstrapSettings();
        settings.setThemeProvider((ThemeProvider)new SingleThemeProvider((ITheme)new AdminLTE()));
        Bootstrap.install((Application)this, (IBootstrapSettings)settings);
        this.getResourceSettings().setUseMinifiedResources(true);
        this.getResourceSettings().setUseDefaultOnMissingResource(true);
        this.getResourceSettings().setThrowExceptionOnMissingResource(false);
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new MetaDataRoleAuthorizationStrategy((IRoleCheckingStrategy)this));
        this.lookup.getIdRepoPageClasses().forEach(cls -> MetaDataRoleAuthorizationStrategy.authorize((Class)cls, (String)"AUTHENTICATED"));
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setCompressWhitespace(true);
        this.getRequestCycleListeners().add((Object)this.buildSyncopeUIRequestCycleListener());
        this.initSecurity();
        this.mountPage("/login", this.getSignInPageClass());
        for (final IResource resource : this.resources) {
            Class resourceClass = AopUtils.getTargetClass((Object)resource);
            Resource annotation = resourceClass.getAnnotation(Resource.class);
            if (annotation == null) {
                LOG.error("No @Resource annotation found, ignoring {}", (Object)resourceClass.getName());
                continue;
            }
            LOG.debug("Mounting {} under {}", (Object)resourceClass.getName(), (Object)annotation.path());
            this.mountResource(annotation.path(), new ResourceReference(annotation.key()){
                private static final long serialVersionUID = -128426276529456602L;

                public IResource getResource() {
                    return resource;
                }
            });
        }
        if (this.getDebugSettings().isAjaxDebugModeEnabled()) {
            this.getDebugSettings().setComponentPathAttributeName("syncope-path");
        }
    }

    protected Class<? extends AbstractAuthenticatedWebSession> getWebSessionClass() {
        return SyncopeConsoleSession.class;
    }

    protected Class<? extends WebPage> getSignInPageClass() {
        return Login.class;
    }

    public Class<? extends Page> getHomePage() {
        return AuthenticatedWebSession.get().isSignedIn() && SyncopeConsoleSession.get().getSelfTO().isMustChangePassword() ? MustChangePassword.class : Dashboard.class;
    }

    public ClassPathScanImplementationLookup getLookup() {
        return this.lookup;
    }

    public Class<? extends BasePage> getPageClass(String name) {
        return this.props.getPage().get(name);
    }

    public ThreadPoolTaskExecutor newThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setWaitForTasksToCompleteOnShutdown(false);
        executor.setCorePoolSize(this.props.getTopology().getCorePoolSize());
        executor.setMaxPoolSize(this.props.getTopology().getMaxPoolSize());
        executor.setQueueCapacity(this.props.getTopology().getQueueCapacity());
        executor.initialize();
        return executor;
    }

    public SyncopeAnonymousClient newAnonymousClient(String domain) {
        return this.newClientFactory().setDomain(domain).createAnonymous(this.props.getAnonymousUser(), this.props.getAnonymousKey());
    }

    public SyncopeClientFactoryBean newClientFactory() {
        return new SyncopeClientFactoryBean().setAddress(this.serviceOps.get(NetworkService.Type.CORE).getAddress()).setUseCompression(this.props.isUseGZIPCompression());
    }

    public String getDefaultAnyPanelClass() {
        return this.props.getDefaultAnyPanelClass();
    }

    public String getAdminUser() {
        return this.props.getAdminUser();
    }

    public String getAnonymousUser() {
        return this.props.getAnonymousUser();
    }

    public String getAnonymousKey() {
        return this.props.getAnonymousKey();
    }

    public long getMaxWaitTimeInSeconds() {
        return this.props.getMaxWaitTimeOnApplyChanges();
    }

    public int getMaxUploadFileSizeMB() {
        return this.props.getMaxUploadFileSizeMB();
    }

    public boolean fullRealmsTree(RealmRestClient restClient) {
        if (this.props.getRealmsFullTreeThreshold() <= 0) {
            return false;
        }
        RealmQuery query = RealmsUtils.buildBaseQuery();
        query.setPage(Integer.valueOf(1));
        query.setSize(Integer.valueOf(0));
        return restClient.search(query).getTotalCount() < this.props.getRealmsFullTreeThreshold();
    }

    public ExternalResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public AnyDirectoryPanelAdditionalActionsProvider getAnyDirectoryPanelAdditionalActionsProvider() {
        return this.anyDirectoryPanelAdditionalActionsProvider;
    }

    public AnyDirectoryPanelAdditionalActionLinksProvider getAnyDirectoryPanelAdditionalActionLinksProvider() {
        return this.anyDirectoryPanelAdditionalActionLinksProvider;
    }

    public AnyWizardBuilderAdditionalSteps getAnyWizardBuilderAdditionalSteps() {
        return this.anyWizardBuilderAdditionalSteps;
    }

    public StatusProvider getStatusProvider() {
        return this.statusProvider;
    }

    public VirSchemaDetailsPanelProvider getVirSchemaDetailsPanelProvider() {
        return this.virSchemaDetailsPanelProvider;
    }

    public ImplementationInfoProvider getImplementationInfoProvider() {
        return this.implementationInfoProvider;
    }

    public Collection<PolicyTabProvider> getPolicyTabProviders() {
        return this.policyTabProviders;
    }

    public List<UserFormFinalizer> getFormFinalizers(AjaxWizard.Mode mode) {
        return this.userFormFinalizers.stream().filter(uff -> {
            Class clazz = AopUtils.getTargetClass((Object)uff);
            UserFormFinalize annotation = clazz.getAnnotation(UserFormFinalize.class);
            if (annotation == null) {
                LOG.error("No @UserFormFinalize annotation found, ignoring {}", (Object)clazz.getName());
                return false;
            }
            return annotation.mode() == mode;
        }).collect(Collectors.toList());
    }

    public AccessPolicyConfProvider getAccessPolicyConfProvider() {
        return this.accessPolicyConfProvider;
    }
}

