/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler.fs;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.collect.BiMap;
import com.google.gxp.com.google.common.collect.Lists;
import com.google.gxp.com.google.common.collect.Maps;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.fs.FileStore;
import com.google.gxp.compiler.fs.FileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class SourcePathFileSystem
implements FileSystem {
    private final BiMap<FileRef, FileRef> spFsToWrappedFsSourceFileRef = Maps.newHashBiMap();
    private final BiMap<FileRef, FileRef> wrappedFsToSpFsSourceFileRef = this.spFsToWrappedFsSourceFileRef.inverse();
    private final FileRef outDir;
    private final FileSystem wrappedFs;
    private static final Comparator<FileRef> FILEREF_LENGTH_COMPARATOR = new Comparator<FileRef>(){

        @Override
        public int compare(FileRef f1, FileRef f2) {
            int len2;
            int len1 = f1.getName().length();
            return len1 > (len2 = f2.getName().length()) ? -1 : (len1 == len2 ? 0 : 1);
        }
    };
    private final FileStore store = new FileStore(){

        @Override
        public Charset getDefaultCharset() {
            return SourcePathFileSystem.this.getDefaultCharset();
        }

        @Override
        public URI toUri(FileRef fileRef) {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).toUri();
        }

        @Override
        public long getLastModified(FileRef fileRef) {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).getLastModified();
        }

        @Override
        public String toFilename(FileRef fileRef) {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).toFilename();
        }

        @Override
        public String toRelativeFilename(FileRef fileRef) {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).toRelativeFilename();
        }

        @Override
        public InputStream openInputStream(FileRef fileRef) throws IOException {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).openInputStream();
        }

        @Override
        public OutputStream openOutputStream(FileRef fileRef) throws IOException {
            FileRef wrappedFsFileRef = SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, true);
            if (wrappedFsFileRef == null) {
                throw new IOException("Attempted to open source file, " + fileRef.toFilename() + ", for writing.");
            }
            return wrappedFsFileRef.openOutputStream();
        }

        @Override
        public boolean delete(FileRef fileRef) {
            return SourcePathFileSystem.this.toWrappedFsFileRef(fileRef, false).delete();
        }
    };
    private final Function<FileRef, FileRef> FROM_WRAPPED_FS_FILEREF = new Function<FileRef, FileRef>(){

        @Override
        public FileRef apply(FileRef fnam) {
            FileRef result = (FileRef)SourcePathFileSystem.this.wrappedFsToSpFsSourceFileRef.get(fnam);
            if (result == null) {
                if (SourcePathFileSystem.this.outDir.isAncestorOf(fnam)) {
                    return SourcePathFileSystem.this.chop(SourcePathFileSystem.this.outDir, fnam);
                }
                throw new IllegalArgumentException(fnam + " not in " + SourcePathFileSystem.this.outDir + " or in source list");
            }
            return result;
        }
    };

    public SourcePathFileSystem(FileSystem wrappedFs, Iterable<FileRef> sourcePath, Iterable<FileRef> sourceFiles, FileRef outDir) {
        this.outDir = outDir;
        this.wrappedFs = wrappedFs;
        List<FileRef> sortedSourcePath = Lists.sortedCopy(sourcePath, FILEREF_LENGTH_COMPARATOR);
        for (FileRef sourceFile : sourceFiles) {
            FileRef baseDir = SourcePathFileSystem.findBaseDir(sourceFile, sortedSourcePath);
            if (baseDir == null) {
                throw new IllegalArgumentException(sourceFile.toFilename() + " not in source path");
            }
            this.spFsToWrappedFsSourceFileRef.put(this.chop(baseDir, sourceFile), sourceFile);
        }
    }

    private static FileRef findBaseDir(FileRef sourceFile, List<FileRef> sourcePath) {
        for (FileRef sourceDir : sourcePath) {
            if (!sourceDir.isAncestorOf(sourceFile)) continue;
            return sourceDir;
        }
        return null;
    }

    private FileRef chop(FileRef ancestor, FileRef descendant) {
        return new FileRef(this.store, descendant.getName().substring(ancestor.getName().length()));
    }

    @Override
    public FileRef getRoot() {
        return new FileRef(this.store, "/");
    }

    @Override
    public FileRef parseFilename(String filename) {
        return this.FROM_WRAPPED_FS_FILEREF.apply(this.wrappedFs.parseFilename(filename));
    }

    @Override
    public List<FileRef> parseFilenameList(String filenameList) {
        return Lists.transform(this.wrappedFs.parseFilenameList(filenameList), this.FROM_WRAPPED_FS_FILEREF);
    }

    @Override
    public Charset getDefaultCharset() {
        return this.wrappedFs.getDefaultCharset();
    }

    public Set<FileRef> getSourceFileRefs() {
        return Collections.unmodifiableSet(this.spFsToWrappedFsSourceFileRef.keySet());
    }

    private FileRef toWrappedFsFileRef(FileRef fnam, boolean forWriting) {
        FileRef result = (FileRef)this.spFsToWrappedFsSourceFileRef.get(fnam);
        if (result == null) {
            result = this.outDir.join(fnam.getName());
        } else if (forWriting) {
            return null;
        }
        return result;
    }
}

