/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.zookeeper.server.embedded;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Properties;
import org.apache.storm.shade.org.apache.zookeeper.server.embedded.ExitHandler;
import org.apache.storm.shade.org.apache.zookeeper.server.embedded.ZooKeeperServerEmbeddedImpl;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface ZooKeeperServerEmbedded
extends AutoCloseable {
    public static ZookKeeperServerEmbeddedBuilder builder() {
        return new ZookKeeperServerEmbeddedBuilder();
    }

    public void start() throws Exception;

    public void start(long var1) throws Exception;

    public String getConnectionString() throws Exception;

    public String getSecureConnectionString() throws Exception;

    @Override
    public void close();

    public static class ZookKeeperServerEmbeddedBuilder {
        private Path baseDir;
        private Properties configuration;
        private ExitHandler exitHandler = ExitHandler.EXIT;

        public ZookKeeperServerEmbeddedBuilder baseDir(Path baseDir) {
            this.baseDir = Objects.requireNonNull(baseDir);
            return this;
        }

        public ZookKeeperServerEmbeddedBuilder configuration(Properties configuration) {
            this.configuration = Objects.requireNonNull(configuration);
            return this;
        }

        public ZookKeeperServerEmbeddedBuilder exitHandler(ExitHandler exitHandler) {
            this.exitHandler = Objects.requireNonNull(exitHandler);
            return this;
        }

        public ZooKeeperServerEmbedded build() throws Exception {
            if (this.baseDir == null) {
                throw new IllegalStateException("baseDir is null");
            }
            if (this.configuration == null) {
                throw new IllegalStateException("configuration is null");
            }
            return new ZooKeeperServerEmbeddedImpl(this.configuration, this.baseDir, this.exitHandler);
        }
    }
}

