/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.io.netty.channel.uring;

import java.io.File;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.apache.storm.shade.io.netty.channel.Channel;
import org.apache.storm.shade.io.netty.channel.ChannelConfig;
import org.apache.storm.shade.io.netty.channel.ChannelFuture;
import org.apache.storm.shade.io.netty.channel.ChannelFutureListener;
import org.apache.storm.shade.io.netty.channel.unix.DomainSocketAddress;
import org.apache.storm.shade.io.netty.channel.unix.ServerDomainSocketChannel;
import org.apache.storm.shade.io.netty.channel.uring.AbstractIoUringServerChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUringDomainSocketChannel;
import org.apache.storm.shade.io.netty.channel.uring.IoUringServerSocketChannelConfig;
import org.apache.storm.shade.io.netty.channel.uring.LinuxSocket;
import org.apache.storm.shade.io.netty.util.concurrent.GenericFutureListener;
import org.apache.storm.shade.io.netty.util.internal.logging.InternalLogger;
import org.apache.storm.shade.io.netty.util.internal.logging.InternalLoggerFactory;

public final class IoUringServerDomainSocketChannel
extends AbstractIoUringServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringServerDomainSocketChannel.class);
    private final IoUringServerSocketChannelConfig config = new IoUringServerSocketChannelConfig(this);
    private volatile DomainSocketAddress local;

    public IoUringServerDomainSocketChannel() {
        super(LinuxSocket.newSocketDomain(), false);
        this.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                File socketFile;
                boolean success;
                if (IoUringServerDomainSocketChannel.this.local != null && !(success = (socketFile = new File(IoUringServerDomainSocketChannel.this.local.path())).delete()) && logger.isDebugEnabled()) {
                    logger.debug("Failed to delete a domain socket file: {}", (Object)IoUringServerDomainSocketChannel.this.local.path());
                }
            }
        });
    }

    @Override
    Channel newChildChannel(int fd, ByteBuffer acceptedAddressMemory) throws Exception {
        return new IoUringDomainSocketChannel((Channel)this, new LinuxSocket(fd));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public DomainSocketAddress localAddress() {
        return this.local;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.socket.bind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)localAddress;
        this.active = true;
    }
}

