/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.container.cgroup;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.storm.container.cgroup.SubSystemType;
import org.apache.storm.container.cgroup.core.BlkioCore;
import org.apache.storm.container.cgroup.core.CgroupCore;
import org.apache.storm.container.cgroup.core.CpuCore;
import org.apache.storm.container.cgroup.core.CpuacctCore;
import org.apache.storm.container.cgroup.core.CpusetCore;
import org.apache.storm.container.cgroup.core.DevicesCore;
import org.apache.storm.container.cgroup.core.FreezerCore;
import org.apache.storm.container.cgroup.core.MemoryCore;
import org.apache.storm.container.cgroup.core.NetClsCore;
import org.apache.storm.container.cgroup.core.NetPrioCore;

public class CgroupCoreFactory {
    public static CgroupCore getInstance(SubSystemType type, String dir) {
        switch (type) {
            case blkio: {
                return new BlkioCore(dir);
            }
            case cpuacct: {
                return new CpuacctCore(dir);
            }
            case cpuset: {
                return new CpusetCore(dir);
            }
            case cpu: {
                return new CpuCore(dir);
            }
            case devices: {
                return new DevicesCore(dir);
            }
            case freezer: {
                return new FreezerCore(dir);
            }
            case memory: {
                return new MemoryCore(dir);
            }
            case net_cls: {
                return new NetClsCore(dir);
            }
            case net_prio: {
                return new NetPrioCore(dir);
            }
        }
        return null;
    }

    public static Map<SubSystemType, CgroupCore> getInstance(Set<SubSystemType> types, String dir) {
        HashMap<SubSystemType, CgroupCore> result2 = new HashMap<SubSystemType, CgroupCore>();
        for (SubSystemType type : types) {
            CgroupCore inst = CgroupCoreFactory.getInstance(type, dir);
            if (inst == null) continue;
            result2.put(type, inst);
        }
        return result2;
    }
}

