/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.supervisor.timer;

import java.util.ArrayList;
import java.util.Map;
import org.apache.storm.daemon.supervisor.Supervisor;
import org.apache.storm.daemon.supervisor.SupervisorUtils;
import org.apache.storm.generated.LSWorkerHeartbeat;
import org.apache.storm.generated.SupervisorWorkerHeartbeat;
import org.apache.storm.generated.SupervisorWorkerHeartbeats;
import org.apache.storm.thrift.TException;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportWorkerHeartbeats
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ReportWorkerHeartbeats.class);
    private Supervisor supervisor;
    private Map<String, Object> conf;

    public ReportWorkerHeartbeats(Map<String, Object> conf, Supervisor supervisor) {
        this.conf = conf;
        this.supervisor = supervisor;
    }

    @Override
    public void run() {
        SupervisorWorkerHeartbeats supervisorWorkerHeartbeats = this.getAndResetWorkerHeartbeats();
        this.reportWorkerHeartbeats(supervisorWorkerHeartbeats);
    }

    private SupervisorWorkerHeartbeats getAndResetWorkerHeartbeats() {
        try {
            Map<String, LSWorkerHeartbeat> localHeartbeats = SupervisorUtils.readWorkerHeartbeats(this.conf);
            return this.getSupervisorWorkerHeartbeatsFromLocal(localHeartbeats);
        }
        catch (Exception e) {
            LOG.error("Read local worker heartbeats error, skipping heartbeats for this round, msg:{}", (Object)e.getMessage());
            return null;
        }
    }

    private SupervisorWorkerHeartbeats getSupervisorWorkerHeartbeatsFromLocal(Map<String, LSWorkerHeartbeat> localHeartbeats) {
        SupervisorWorkerHeartbeats supervisorWorkerHeartbeats = new SupervisorWorkerHeartbeats();
        ArrayList<SupervisorWorkerHeartbeat> heartbeatList = new ArrayList<SupervisorWorkerHeartbeat>();
        for (LSWorkerHeartbeat lsWorkerHeartbeat : localHeartbeats.values()) {
            if (null == lsWorkerHeartbeat) continue;
            SupervisorWorkerHeartbeat supervisorWorkerHeartbeat = new SupervisorWorkerHeartbeat();
            supervisorWorkerHeartbeat.set_storm_id(lsWorkerHeartbeat.get_topology_id());
            supervisorWorkerHeartbeat.set_executors(lsWorkerHeartbeat.get_executors());
            supervisorWorkerHeartbeat.set_time_secs(lsWorkerHeartbeat.get_time_secs());
            heartbeatList.add(supervisorWorkerHeartbeat);
        }
        supervisorWorkerHeartbeats.set_supervisor_id(this.supervisor.getId());
        supervisorWorkerHeartbeats.set_worker_heartbeats(heartbeatList);
        return supervisorWorkerHeartbeats;
    }

    private void reportWorkerHeartbeats(SupervisorWorkerHeartbeats supervisorWorkerHeartbeats) {
        if (supervisorWorkerHeartbeats == null) {
            return;
        }
        if (this.supervisor.getStormClusterState().isPacemakerStateStore()) {
            LOG.debug("Worker are using pacemaker to send worker heartbeats so skip reporting by supervisor.");
            return;
        }
        if (ConfigUtils.isLocalMode(this.conf)) {
            try {
                this.supervisor.getLocalNimbus().sendSupervisorWorkerHeartbeats(supervisorWorkerHeartbeats);
            }
            catch (TException tex) {
                LOG.error("Send local supervisor heartbeats error", (Throwable)tex);
            }
        } else {
            try (NimbusClient master = NimbusClient.Builder.withConf(this.conf).forDaemon().build();){
                master.getClient().sendSupervisorWorkerHeartbeats(supervisorWorkerHeartbeats);
            }
            catch (Exception t) {
                LOG.error("Send worker heartbeats to master exception", (Throwable)t);
            }
        }
    }
}

