/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter.math;

import java.io.ObjectStreamException;
import java.util.Objects;
import java.util.function.DoubleBinaryOperator;
import org.apache.sis.feature.internal.shared.FeatureExpression;
import org.apache.sis.feature.internal.shared.FeatureProjectionBuilder;
import org.apache.sis.filter.Expression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.base.BinaryFunction;
import org.apache.sis.filter.math.Function;
import org.opengis.util.ScopedName;

final class BinaryOperator<R>
extends BinaryFunction<R, Number, Number>
implements FeatureExpression<R, Double>,
Optimization.OnExpression<R, Double> {
    private static final long serialVersionUID = 8021641013005967925L;
    private final Function function;
    private final transient DoubleBinaryOperator math;

    BinaryOperator(Function function, Expression<R, ? extends Number> expression1, Expression<R, ? extends Number> expression2) {
        super(expression1, expression2);
        this.function = function;
        this.math = Objects.requireNonNull(function.binary);
    }

    private Object readResolve() throws ObjectStreamException {
        return new BinaryOperator<R>(this.function, this.expression1, this.expression2);
    }

    @Override
    public ScopedName getFunctionName() {
        return this.function.getFunctionName();
    }

    @Override
    public final Class<Double> getResultClass() {
        return Double.class;
    }

    @Override
    public final FeatureProjectionBuilder.Item expectedType(FeatureProjectionBuilder addTo) {
        return addTo.addSourceProperty(this.function.getResultType(), false);
    }

    @Override
    public final Double apply(R feature) {
        Number right;
        Number left = (Number)this.expression1.apply(feature);
        if (left != null && (right = (Number)this.expression2.apply(feature)) != null) {
            return this.math.applyAsDouble(left.doubleValue(), right.doubleValue());
        }
        return null;
    }
}

