/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sis.coverage.grid.FractionalGridCoordinates;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.internal.shared.BandAggregateArgument;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.DataType;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.util.collection.Containers;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.TransformException;

final class BandAggregateGridCoverage
extends GridCoverage {
    private final GridCoverage[] sources;
    private final int[][] bandsPerSource;
    private final int numBands;
    private final long[][] gridTranslations;
    private final int sourceOfGridToCRS;
    private final DataType dataType;
    private final ImageProcessor processor;

    BandAggregateGridCoverage(BandAggregateArgument<GridCoverage> aggregate, ImageProcessor processor) {
        super(aggregate.domain(GridCoverage::getGridGeometry), aggregate.ranges());
        this.sources = aggregate.sources();
        this.bandsPerSource = aggregate.bandsPerSource(true);
        this.numBands = aggregate.numBands();
        this.gridTranslations = aggregate.gridTranslations();
        this.sourceOfGridToCRS = aggregate.sourceOfGridToCRS();
        this.processor = processor;
        this.dataType = this.sources[0].getBandType();
        for (int i = 1; i < this.sources.length; ++i) {
            GridCoverage source = this.sources[i];
            DataType type = source.getBandType();
            if (this.dataType.equals((Object)type)) continue;
            throw new IllegalArgumentException(Resources.format((short)42));
        }
    }

    static void unwrap(BandAggregateArgument.Unwrapper unwrapper) {
        if (unwrapper.source instanceof BandAggregateGridCoverage) {
            BandAggregateGridCoverage aggregate = (BandAggregateGridCoverage)unwrapper.source;
            unwrapper.applySubset(aggregate.sources, aggregate.bandsPerSource, GridCoverage::getSampleDimensions);
        }
    }

    @Override
    DataType getBandType() {
        return this.dataType;
    }

    @Override
    public RenderedImage render(GridExtent sliceExtent) {
        if (sliceExtent == null) {
            sliceExtent = this.gridGeometry.getExtent();
        }
        RenderedImage[] images = new RenderedImage[this.sources.length];
        for (int i = 0; i < images.length; ++i) {
            images[i] = this.sources[i].render(sliceExtent.translate(this.gridTranslations[i]));
        }
        return this.processor.aggregateBands(images, this.bandsPerSource);
    }

    @Override
    public GridCoverage.Evaluator evaluator() {
        return new CombinedEvaluator(this.sources);
    }

    private final class CombinedEvaluator
    implements GridCoverage.Evaluator {
        private final GridCoverage.Evaluator[] sources;
        private Map<Integer, Long> slices;
        private final double[] aggregate;

        CombinedEvaluator(GridCoverage[] coverages) {
            this.sources = new GridCoverage.Evaluator[coverages.length];
            for (int i = 0; i < coverages.length; ++i) {
                this.sources[i] = coverages[i].evaluator();
            }
            this.aggregate = new double[BandAggregateGridCoverage.this.numBands];
        }

        @Override
        public GridCoverage getCoverage() {
            return BandAggregateGridCoverage.this;
        }

        @Override
        public Map<Integer, Long> getDefaultSlice() {
            if (this.slices == null) {
                TreeMap<Integer, Long> c = new TreeMap<Integer, Long>();
                for (GridCoverage.Evaluator source : this.sources) {
                    c.putAll(source.getDefaultSlice());
                }
                this.slices = Containers.unmodifiable(c);
            }
            return this.slices;
        }

        @Override
        public void setDefaultSlice(Map<Integer, Long> slice) {
            this.slices = null;
            for (GridCoverage.Evaluator source : this.sources) {
                source.setDefaultSlice(slice);
            }
        }

        @Override
        public boolean isNullIfOutside() {
            for (GridCoverage.Evaluator source : this.sources) {
                if (source.isNullIfOutside()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void setNullIfOutside(boolean flag) {
            for (GridCoverage.Evaluator source : this.sources) {
                source.setNullIfOutside(flag);
            }
        }

        @Override
        public boolean isWraparoundEnabled() {
            for (GridCoverage.Evaluator source : this.sources) {
                if (source.isWraparoundEnabled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public void setWraparoundEnabled(boolean allow) {
            for (GridCoverage.Evaluator source : this.sources) {
                source.setWraparoundEnabled(allow);
            }
        }

        @Override
        public double[] apply(DirectPosition point) {
            int offset = 0;
            for (int i = 0; i < this.sources.length; ++i) {
                double[] values = this.sources[i].apply(point);
                int[] bands = BandAggregateGridCoverage.this.bandsPerSource[i];
                if (bands == null) {
                    System.arraycopy(values, 0, this.aggregate, offset, values.length);
                    offset += values.length;
                    continue;
                }
                for (int b : bands) {
                    this.aggregate[offset++] = values[b];
                }
            }
            return this.aggregate;
        }

        @Override
        public FractionalGridCoordinates toGridCoordinates(DirectPosition point) throws TransformException {
            if (BandAggregateGridCoverage.this.sourceOfGridToCRS >= 0) {
                return this.sources[BandAggregateGridCoverage.this.sourceOfGridToCRS].toGridCoordinates(point);
            }
            throw new UnsupportedOperationException();
        }
    }
}

