/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.console;

import java.io.Console;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.sis.console.CommandRunner;
import org.apache.sis.pending.jdk.JDK22;
import org.apache.sis.setup.OptionalInstallations;
import org.apache.sis.system.Environment;
import org.apache.sis.system.Fallback;
import org.apache.sis.util.internal.shared.X364;

@Fallback
public class ResourcesDownloader
extends OptionalInstallations {
    private final Console console;
    private final PrintWriter out;
    private final Locale locale;
    private final boolean colors;
    private final Map<String, Boolean> answers = new HashMap<String, Boolean>();

    public ResourcesDownloader() {
        super("text/plain");
        CommandRunner command = CommandRunner.instance.get();
        if (command != null) {
            this.locale = command.locale;
            this.colors = command.colors;
        } else {
            this.locale = Locale.getDefault();
            this.colors = false;
        }
        this.console = System.console();
        this.out = Environment.writer((Console)this.console, (PrintStream)System.out);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Set<String> getAuthorities() {
        return this.console != null && JDK22.isTerminal((Console)this.console) ? super.getAuthorities() : Set.of();
    }

    protected boolean askUserAgreement(String authority, String license) {
        Boolean answer;
        String action;
        String prompt;
        String resetColor;
        String actionColor;
        String linkOff;
        String linkColor;
        String textColor;
        if (this.console == null) {
            return false;
        }
        ResourceBundle resources = ResourceBundle.getBundle("org.apache.sis.console.Messages", this.getLocale());
        if (this.answers.isEmpty()) {
            for (String r : resources.getString("yes").split("\\|")) {
                this.answers.put(r, Boolean.TRUE);
            }
            for (String r : resources.getString("no").split("\\|")) {
                this.answers.put(r, Boolean.FALSE);
            }
        }
        if (this.colors) {
            textColor = X364.FOREGROUND_YELLOW.sequence();
            linkColor = X364.UNDERLINE.sequence();
            linkOff = X364.NO_UNDERLINE.sequence();
            actionColor = X364.FOREGROUND_GREEN.sequence();
            resetColor = X364.FOREGROUND_DEFAULT.sequence();
        } else {
            resetColor = "";
            actionColor = "";
            linkOff = "";
            linkColor = "";
            textColor = "";
        }
        String lineSeparator = System.lineSeparator();
        if (license == null) {
            prompt = "download";
            action = "downloading";
            this.format(resources.getString("install"), textColor, this.getSpaceRequirement(authority), linkColor, this.destinationDirectory, linkOff, resetColor);
        } else {
            prompt = "accept";
            action = "installing";
            this.out.write(lineSeparator);
            this.out.write(license);
            this.out.write(lineSeparator);
        }
        this.out.flush();
        while ((answer = this.answers.get(this.console.readLine(resources.getString(prompt), textColor, resetColor).toLowerCase(this.getLocale()))) == null) {
        }
        if (answer.booleanValue()) {
            this.format(resources.getString(action), actionColor, resetColor);
        } else {
            this.out.write(lineSeparator);
        }
        return answer;
    }

    private void format(String pattern, Object ... args) {
        if (this.console.writer() == this.out) {
            this.console.format(pattern, args);
        } else {
            this.out.format(pattern, args);
        }
    }
}

