/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.metadata.identification;

import java.util.Collection;
import org.opengis.annotation.ComplianceLevel;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Profile;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.distribution.Format;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.metadata.identification.Keywords;
import org.opengis.metadata.identification.Progress;
import org.opengis.metadata.identification.Usage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.util.InternationalString;

@UML(identifier="MD_Identification", specification=Specification.ISO_19115)
public interface Identification {
    @UML(identifier="citation", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Citation getCitation();

    @UML(identifier="abstract", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public InternationalString getAbstract();

    @UML(identifier="purpose", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InternationalString getPurpose();

    @UML(identifier="credit", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<String> getCredits();

    @UML(identifier="status", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Progress> getStatus();

    @UML(identifier="pointOfContact", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    @Profile(level=ComplianceLevel.CORE)
    public Collection<? extends ResponsibleParty> getPointOfContacts();

    @UML(identifier="resourceMaintenance", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends MaintenanceInformation> getResourceMaintenances();

    @UML(identifier="graphicOverview", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends BrowseGraphic> getGraphicOverviews();

    @UML(identifier="resourceFormat", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Format> getResourceFormats();

    @UML(identifier="descriptiveKeywords", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Keywords> getDescriptiveKeywords();

    @UML(identifier="resourceSpecificUsage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Usage> getResourceSpecificUsages();

    @UML(identifier="resourceConstraints", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends Constraints> getResourceConstraints();

    @UML(identifier="aggregationInfo", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<? extends AggregateInformation> getAggregationInfo();
}

