/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api.patterns;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Utils;
import java.util.Map;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementNode;
import org.apache.servicecomb.foundation.metrics.publish.spectator.MeasurementTree;
import org.apache.servicecomb.metrics.core.ThreadPoolMetersInitializer;
import org.apache.servicecomb.metrics.core.publish.model.ThreadPoolPublishModel;

public class ThreadPoolMonitorPublishModelFactory {
    private final MeasurementTree tree;
    private final Map<String, ThreadPoolPublishModel> threadPools;

    public ThreadPoolMonitorPublishModelFactory(MeasurementTree tree, Map<String, ThreadPoolPublishModel> threadPools) {
        this.tree = tree;
        this.threadPools = threadPools;
    }

    public static void create(MeasurementTree tree, Map<String, ThreadPoolPublishModel> threadPools) {
        new ThreadPoolMonitorPublishModelFactory(tree, threadPools).create();
    }

    public void create() {
        this.readMeasurement("threadpool.taskCount", (model, measurement) -> model.setAvgTaskCount(measurement.value()));
        this.readMeasurement("threadpool.completedTaskCount", (model, measurement) -> model.setAvgCompletedTaskCount(measurement.value()));
        this.readMeasurement("threadpool.currentThreadsBusy", (model, measurement) -> model.setCurrentThreadsBusy((int)measurement.value()));
        this.readMeasurement("threadpool.maxThreads", (model, measurement) -> model.setMaxThreads((int)measurement.value()));
        this.readMeasurement("threadpool.poolSize", (model, measurement) -> model.setPoolSize((int)measurement.value()));
        this.readMeasurement("threadpool.corePoolSize", (model, measurement) -> model.setCorePoolSize((int)measurement.value()));
        this.readMeasurement("threadpool.queueSize", (model, measurement) -> model.setQueueSize((int)measurement.value()));
        this.readMeasurement(ThreadPoolMetersInitializer.REJECTED_COUNT, (model, measurement) -> model.setRejected(measurement.value()));
    }

    protected void readMeasurement(String name, Setter setter) {
        MeasurementNode node = this.tree.findChild(name);
        if (node == null) {
            return;
        }
        for (Measurement measurement : node.getMeasurements()) {
            String threadPoolName = Utils.getTagValue((Id)measurement.id(), (String)"id");
            if (threadPoolName == null) continue;
            ThreadPoolPublishModel model = this.threadPools.computeIfAbsent(threadPoolName, tpn -> new ThreadPoolPublishModel());
            setter.set(model, measurement);
        }
    }

    static interface Setter {
        public void set(ThreadPoolPublishModel var1, Measurement var2);
    }
}

