/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.governance.policy;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.governance.entity.Configurable;

public abstract class AbstractPolicy
extends Configurable
implements Comparable<AbstractPolicy> {
    protected int order = 0;

    @Override
    public boolean isValid() {
        return !StringUtils.isEmpty((CharSequence)this.name);
    }

    @Override
    public int compareTo(AbstractPolicy o) {
        return this.order - o.order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    private Duration parseToDuration(String time, Duration defaultValue) {
        if (StringUtils.isEmpty((CharSequence)time)) {
            return defaultValue;
        }
        if (time.matches("-{0,1}[0-9]{1,10}")) {
            if (Long.parseLong(time) < 0L) {
                throw new RuntimeException("The value of time should not be less than 0.");
            }
            return Duration.ofMillis(Long.parseLong(time));
        }
        return Duration.parse("PT" + time);
    }

    public String stringOfDuration(String time, Duration defaultValue) {
        return this.parseToDuration(time, defaultValue).toString();
    }
}

