/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.rocksdb;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.store.config.MessageStoreConfig;
import org.apache.rocketmq.store.index.rocksdb.IndexRocksDBRecord;
import org.apache.rocketmq.store.rocksdb.RocksDBOptionsFactory;
import org.apache.rocketmq.store.timer.rocksdb.TimerRocksDBRecord;
import org.apache.rocketmq.store.transaction.TransRocksDBRecord;
import org.rocksdb.AbstractSlice;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.WriteBatch;

public class MessageRocksDBStorage
extends AbstractRocksDBStorage {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqStore");
    private static final Logger logError = LoggerFactory.getLogger((String)"RocketmqStoreError");
    private static final String ROCKSDB_MESSAGE_DIRECTORY = "rocksdbstore";
    public static final byte[] TIMER_COLUMN_FAMILY = "timer".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TRANS_COLUMN_FAMILY = "trans".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LAST_OFFSET_PY = "lastOffsetPy".getBytes(StandardCharsets.UTF_8);
    private static final byte[] LAST_STORE_TIMESTAMP = "lastStoreTimeStamp".getBytes(StandardCharsets.UTF_8);
    private static final byte[] END_SUFFIX_BYTES = new byte[512];
    private static final Set<byte[]> COMMON_CHECK_POINT_KEY_SET_FOR_TIMER;
    public static final byte[] SYS_TOPIC_SCAN_OFFSET_CHECK_POINT;
    public static final byte[] TIMELINE_CHECK_POINT;
    private static final byte[] DELETE_VAL_FLAG;
    private static final int LAST_OFFSET_PY_LENGTH;
    private volatile ColumnFamilyHandle timerCFHandle;
    private volatile ColumnFamilyHandle transCFHandle;
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private static final Cache<byte[], byte[]> DELETE_KEY_CACHE_FOR_TIMER;

    public MessageRocksDBStorage(MessageStoreConfig messageStoreConfig) {
        super(Paths.get(messageStoreConfig.getStorePathRootDir(), ROCKSDB_MESSAGE_DIRECTORY).toString());
        this.start();
    }

    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK((String)this.dbPath);
            this.initOptions();
            ColumnFamilyOptions indexCFOptions = RocksDBOptionsFactory.createIndexCFOptions();
            ColumnFamilyOptions timerCFOptions = RocksDBOptionsFactory.createTimerCFOptions();
            ColumnFamilyOptions transCFOptions = RocksDBOptionsFactory.createTransCFOptions();
            this.cfOptions.add(indexCFOptions);
            this.cfOptions.add(timerCFOptions);
            this.cfOptions.add(transCFOptions);
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, indexCFOptions));
            cfDescriptors.add(new ColumnFamilyDescriptor(TIMER_COLUMN_FAMILY, timerCFOptions));
            cfDescriptors.add(new ColumnFamilyDescriptor(TRANS_COLUMN_FAMILY, transCFOptions));
            this.open(cfDescriptors);
            this.defaultCFHandle = (ColumnFamilyHandle)this.cfHandles.get(0);
            this.timerCFHandle = (ColumnFamilyHandle)this.cfHandles.get(1);
            this.transCFHandle = (ColumnFamilyHandle)this.cfHandles.get(2);
            this.scheduler.scheduleAtFixedRate(() -> {
                try {
                    this.db.flush(this.flushOptions, this.timerCFHandle);
                    log.info("MessageRocksDBStorage flush timer wal success");
                }
                catch (Exception e) {
                    logError.error("MessageRocksDBStorage flush timer wal failed, error: {}", (Object)e.getMessage());
                }
            }, 5L, 5L, TimeUnit.MINUTES);
            log.info("MessageRocksDBStorage init success, dbPath: {}", (Object)this.dbPath);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage init error, dbPath: {}, error: {}", (Object)this.dbPath, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    protected void initOptions() {
        this.options = RocksDBOptionsFactory.createDBOptions();
        super.initOptions();
    }

    public String getFilePath() {
        return this.dbPath;
    }

    protected void preShutdown() {
        log.info("MessageRocksDBStorage pre shutdown success, dbPath: {}", (Object)this.dbPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Long> queryOffsetForIndex(byte[] columnFamily, String topic, String indexType, String key, long beginTime, long endTime, int maxNum, String lastKey) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || StringUtils.isEmpty((CharSequence)topic) || StringUtils.isEmpty((CharSequence)indexType) || StringUtils.isEmpty((CharSequence)key) || beginTime < 0L || endTime <= 0L || beginTime > endTime || maxNum <= 0) {
            logError.error("MessageRocksDBStorage queryOffsetForIndex param error, cfHandle: {}, topic: {}, indexType: {}, key: {}, beginTime: {}, endTime: {}, maxNum: {}", new Object[]{cfHandle, topic, indexType, key, beginTime, endTime, maxNum});
            return null;
        }
        Long lastIndexTime = MessageRocksDBStorage.getLastIndexTimeForIndex(lastKey);
        if (!(StringUtils.isEmpty((CharSequence)lastKey) || null != lastIndexTime && lastIndexTime > 0L && MixAll.isHourTime((Long)lastIndexTime))) {
            logError.error("MessageRocksDBStorage queryOffsetForIndex parse and check lastIndexTime error, lastIndexTime: {}, lastKey: {}", (Object)lastIndexTime, (Object)lastKey);
            return null;
        }
        List hours = MixAll.getHours((long)beginTime, (long)endTime);
        if (CollectionUtils.isEmpty((Collection)hours)) {
            logError.error("MessageRocksDBStorage queryOffsetForIndex param error, hours is empty, beginTime: {}, endTime: {}", (Object)beginTime, (Object)endTime);
            return null;
        }
        ArrayList<Long> offsetPyList = new ArrayList<Long>(maxNum);
        String keyMiddleStr = "@" + topic + "@" + indexType + "@" + key + "@";
        byte[] keyMiddleBytes = keyMiddleStr.getBytes(StandardCharsets.UTF_8);
        Iterator iterator = hours.iterator();
        block16: while (iterator.hasNext()) {
            Long hour = (Long)iterator.next();
            if (null == hour || null != lastIndexTime && hour < lastIndexTime) continue;
            byte[] seekKeyBytes = null;
            byte[] lastKeyBytes = null;
            byte[] keyPrefixBytes = ByteBuffer.allocate(8 + keyMiddleBytes.length).putLong(hour).put(keyMiddleBytes).array();
            if (!StringUtils.isEmpty((CharSequence)lastKey) && hour.equals(lastIndexTime)) {
                lastKeyBytes = seekKeyBytes = this.lastKeyToBytes(lastKey);
            } else {
                seekKeyBytes = keyPrefixBytes;
            }
            if (null == seekKeyBytes) {
                logError.error("MessageRocksDBStorage queryOffsetForIndex error, seekKeyBytes is null");
                return null;
            }
            try {
                RocksIterator iterator2 = this.db.newIterator(cfHandle, this.readOptions);
                Throwable throwable = null;
                try {
                    iterator2.seek(seekKeyBytes);
                    while (true) {
                        block27: {
                            if (!iterator2.isValid()) continue block16;
                            try {
                                byte[] indexKey;
                                byte[] currentKeyBytes = iterator2.key();
                                if (null == currentKeyBytes || currentKeyBytes.length == 0) continue block16;
                                if (null != lastKeyBytes && currentKeyBytes.length == lastKeyBytes.length && MixAll.isByteArrayEqual((byte[])currentKeyBytes, (int)0, (int)currentKeyBytes.length, (byte[])lastKeyBytes, (int)0, (int)lastKeyBytes.length)) break block27;
                                if (currentKeyBytes.length < keyPrefixBytes.length || !MixAll.isByteArrayEqual((byte[])currentKeyBytes, (int)0, (int)keyPrefixBytes.length, (byte[])keyPrefixBytes, (int)0, (int)keyPrefixBytes.length)) continue block16;
                                ByteBuffer valueBuffer = ByteBuffer.wrap(iterator2.value());
                                long storeTime = valueBuffer.getLong();
                                if (storeTime >= beginTime && storeTime <= endTime && null != (indexKey = iterator2.key()) && indexKey.length >= 8) {
                                    byte[] bytes = Arrays.copyOfRange(indexKey, indexKey.length - 8, indexKey.length);
                                    long offset = ByteBuffer.wrap(bytes).getLong();
                                    offsetPyList.add(offset);
                                    if (offsetPyList.size() >= maxNum) {
                                        ArrayList<Long> arrayList = offsetPyList;
                                        return arrayList;
                                    }
                                }
                            }
                            catch (Exception e) {
                                logError.error("MessageRocksDBStorage queryOffsetForIndex iterator error: {}", (Object)e.getMessage());
                            }
                        }
                        iterator2.next();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iterator2 == null) continue;
                    if (throwable != null) {
                        try {
                            iterator2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iterator2.close();
                }
            }
            catch (Exception e) {
                logError.error("MessageRocksDBStorage queryOffsetForIndex error: {}", (Object)e.getMessage());
            }
        }
        return offsetPyList;
    }

    private byte[] lastKeyToBytes(String lastKey) {
        if (StringUtils.isEmpty((CharSequence)lastKey)) {
            return null;
        }
        String[] split = lastKey.split("@");
        if (split.length != 6) {
            log.error("MessageRocksDBStorage lastKeyToBytes split error, lastKey: {}", (Object)lastKey);
            return null;
        }
        try {
            long storeTimeHour = Long.parseLong(split[0]);
            long offsetPy = Long.parseLong(split[split.length - 1]);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 1; i < split.length - 1; ++i) {
                stringBuilder.append("@").append(split[i]);
            }
            byte[] middleKeyBytes = stringBuilder.append("@").toString().getBytes(StandardCharsets.UTF_8);
            return ByteBuffer.allocate(8 + middleKeyBytes.length + 8).putLong(storeTimeHour).put(middleKeyBytes).putLong(offsetPy).array();
        }
        catch (Exception e) {
            log.error("MessageRocksDBStorage lastKeyToBytes error, lastKey: {}, error: {}", (Object)lastKey, (Object)e.getMessage());
            return null;
        }
    }

    public void deleteRecordsForIndex(byte[] columnFamily, long storeTime, int hours) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || storeTime < 0L || hours <= 0) {
            logError.error("MessageRocksDBStorage deleteRecordsForIndex param error, storeTime: {}, hours: {}", (Object)storeTime, (Object)hours);
            return;
        }
        long endTime = MixAll.dealTimeToHourStamps((long)storeTime);
        long startTime = endTime - TimeUnit.HOURS.toMillis(hours);
        try {
            byte[] startKey = ByteBuffer.allocate(8 + IndexRocksDBRecord.KEY_SPLIT_BYTES.length).putLong(startTime).put(IndexRocksDBRecord.KEY_SPLIT_BYTES).array();
            byte[] endKey = ByteBuffer.allocate(8 + IndexRocksDBRecord.KEY_SPLIT_BYTES.length + END_SUFFIX_BYTES.length).putLong(endTime).put(IndexRocksDBRecord.KEY_SPLIT_BYTES).put(END_SUFFIX_BYTES).array();
            this.rangeDelete(cfHandle, this.ableWalWriteOptions, startKey, endKey);
            log.info("MessageRocksDBStorage deleteRecordsForIndex delete success, storeTime: {}, hours: {}", (Object)storeTime, (Object)hours);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage deleteRecordsForIndex delete error, storeTime: {}, hours: {}, error: {}", new Object[]{storeTime, hours, e.getMessage()});
        }
    }

    public void writeRecordsForIndex(byte[] columnFamily, List<IndexRocksDBRecord> recordList) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || CollectionUtils.isEmpty(recordList)) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            for (IndexRocksDBRecord record : recordList) {
                try {
                    if (null == record) {
                        logError.warn("MessageRocksDBStorage writeRecordsForIndex error, record is null");
                        continue;
                    }
                    byte[] keyBytes = record.getKeyBytes();
                    byte[] valueBytes = record.getValueBytes();
                    if (null == keyBytes || keyBytes.length == 0 || null == valueBytes || valueBytes.length == 0) {
                        logError.error("MessageRocksDBStorage writeRecordsForIndex param error, keyBytes: {}, valueBytes: {}", (Object)keyBytes, (Object)valueBytes);
                        continue;
                    }
                    writeBatch.put(cfHandle, keyBytes, valueBytes);
                }
                catch (Exception e) {
                    logError.error("MessageRocksDBStorage writeRecordsForIndex error: {}", (Object)e.getMessage());
                }
            }
            IndexRocksDBRecord lastRecord = recordList.get(recordList.size() - 1);
            if (null != lastRecord && StringUtils.isEmpty((CharSequence)lastRecord.getKey()) && StringUtils.isEmpty((CharSequence)lastRecord.getTag())) {
                long offset = lastRecord.getOffsetPy();
                Long lastOffsetPy = this.getLastOffsetPy(columnFamily);
                if (null == lastOffsetPy || offset > lastOffsetPy) {
                    writeBatch.put(cfHandle, LAST_OFFSET_PY, ByteBuffer.allocate(8).putLong(offset).array());
                }
                long storeTime = lastRecord.getStoreTime();
                Long lastStoreTimeStamp = this.getLastStoreTimeStampForIndex(columnFamily);
                if (null == lastStoreTimeStamp || storeTime > lastStoreTimeStamp) {
                    writeBatch.put(cfHandle, LAST_STORE_TIMESTAMP, ByteBuffer.allocate(8).putLong(storeTime).array());
                }
            }
            this.batchPut(this.ableWalWriteOptions, writeBatch);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage writeRecordsForIndex error: {}", (Object)e.getMessage());
        }
    }

    public Long getLastStoreTimeStampForIndex(byte[] columnFamily) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle) {
            return null;
        }
        try {
            byte[] storeTime = this.get(cfHandle, this.readOptions, LAST_STORE_TIMESTAMP);
            return null == storeTime ? 0L : ByteBuffer.wrap(storeTime).getLong();
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage getLastStoreTimeStampForIndex error: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static Long getLastIndexTimeForIndex(String lastKey) {
        if (StringUtils.isEmpty((CharSequence)lastKey)) {
            return null;
        }
        try {
            String[] split = lastKey.split("@");
            if (split.length > 0) {
                return Long.valueOf(split[0]);
            }
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage getLastIndexTimeForIndex error lastKey: {}, e: {}", (Object)lastKey, (Object)e.getMessage());
        }
        return null;
    }

    public void writeRecordsForTimer(byte[] columnFamily, List<TimerRocksDBRecord> recordList) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || CollectionUtils.isEmpty(recordList)) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            for (TimerRocksDBRecord record : recordList) {
                if (null == record) {
                    logError.error("MessageRocksDBStorage writeRecordsForTimer error, record is null");
                    continue;
                }
                try {
                    byte[] keyBytes = record.getKeyBytes();
                    byte[] valueBytes = record.getValueBytes();
                    if (null == keyBytes || keyBytes.length == 0 || null == valueBytes || valueBytes.length == 0) {
                        logError.error("MessageRocksDBStorage writeRecordsForTimer param error, keyBytes: {}, valueBytes: {}", (Object)keyBytes, (Object)valueBytes);
                        continue;
                    }
                    if (record.getActionFlag() == 0) {
                        writeBatch.put(cfHandle, keyBytes, valueBytes);
                        continue;
                    }
                    if (record.getActionFlag() == 1) {
                        writeBatch.delete(cfHandle, keyBytes);
                        DELETE_KEY_CACHE_FOR_TIMER.put((Object)keyBytes, (Object)DELETE_VAL_FLAG);
                        continue;
                    }
                    if (record.getActionFlag() == 2) {
                        byte[] deleteByte = (byte[])DELETE_KEY_CACHE_FOR_TIMER.getIfPresent((Object)keyBytes);
                        if (null != deleteByte) continue;
                        writeBatch.put(cfHandle, keyBytes, valueBytes);
                        continue;
                    }
                    logError.error("MessageRocksDBStorage writeRecordsForTimer record actionFlag error, actionFlag: {}", (Object)record.getActionFlag());
                }
                catch (Exception e) {
                    logError.error("MessageRocksDBStorage writeRecordsForTimer error: {}", (Object)e.getMessage());
                }
            }
            this.batchPut(this.ableWalWriteOptions, writeBatch);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage writeRecordsForTimer error: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<TimerRocksDBRecord> scanRecordsForTimer(byte[] columnFamily, long lowerTime, long upperTime, int size, byte[] startKey) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || lowerTime <= 0L || upperTime <= 0L || lowerTime > upperTime || size <= 0) {
            return null;
        }
        RocksIterator iterator = null;
        try {
            ArrayList<TimerRocksDBRecord> arrayList;
            Throwable throwable;
            ReadOptions readOptions;
            block27: {
                block28: {
                    readOptions = new ReadOptions().setIterateLowerBound((AbstractSlice)new Slice(ByteBuffer.allocate(8).putLong(lowerTime).array())).setIterateUpperBound((AbstractSlice)new Slice(ByteBuffer.allocate(8).putLong(upperTime).array()));
                    throwable = null;
                    iterator = this.db.newIterator(cfHandle, readOptions);
                    if (null == startKey || startKey.length == 0) {
                        iterator.seek(ByteBuffer.allocate(8).putLong(lowerTime).array());
                    } else {
                        iterator.seek(startKey);
                        iterator.next();
                    }
                    ArrayList<TimerRocksDBRecord> records = new ArrayList<TimerRocksDBRecord>();
                    while (iterator.isValid()) {
                        try {
                            TimerRocksDBRecord timerRocksDBRecord = TimerRocksDBRecord.decode(iterator.key(), iterator.value());
                            if (null == timerRocksDBRecord) {
                                logError.error("MessageRocksDBStorage scanRecordsForTimer error, decode timerRocksDBRecord is null");
                            } else {
                                records.add(timerRocksDBRecord);
                                if (records.size() >= size) {
                                    break;
                                }
                            }
                        }
                        catch (Exception e) {
                            logError.error("MessageRocksDBStorage scanRecordsForTimer iterator error: {}", (Object)e.getMessage());
                        }
                        iterator.next();
                    }
                    arrayList = records;
                    if (readOptions == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        readOptions.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block27;
                }
                readOptions.close();
            }
            return arrayList;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (readOptions != null) {
                            if (throwable != null) {
                                try {
                                    readOptions.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                readOptions.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    logError.error("MessageRocksDBStorage scanRecordsForTimer error: {}", (Object)e.getMessage());
                }
            }
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return null;
    }

    public void deleteRecordsForTimer(byte[] columnFamily, long lowerTime, long upperTime) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || lowerTime <= 0L || upperTime <= 0L || lowerTime > upperTime) {
            logError.error("MessageRocksDBStorage deleteRecordsForTimer param error, cfHandle: {}, lowerTime: {}, upperTime: {}", new Object[]{cfHandle, lowerTime, upperTime});
            return;
        }
        byte[] startKey = ByteBuffer.allocate(8).putLong(lowerTime).array();
        byte[] endKey = ByteBuffer.allocate(8 + END_SUFFIX_BYTES.length).putLong(upperTime).put(END_SUFFIX_BYTES).array();
        try {
            this.rangeDelete(cfHandle, this.ableWalWriteOptions, startKey, endKey);
            log.info("MessageRocksDBStorage deleteRecordsForTimer success, lowerTime: {}, upperTime: {}", (Object)lowerTime, (Object)upperTime);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage deleteRecordsForTimer param error, lowerTime: {}, upperTime: {}, error: {}", new Object[]{lowerTime, upperTime, e.getMessage()});
        }
    }

    public void writeCheckPointForTimer(byte[] columnFamily, byte[] key, long value) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || !COMMON_CHECK_POINT_KEY_SET_FOR_TIMER.contains(key) || value < 0L) {
            logError.error("MessageRocksDBStorage writeCheckPointForTimer param error, cfHandle: {}, key: {}, value: {}", new Object[]{cfHandle, key, value});
            return;
        }
        try {
            byte[] valueBytes = ByteBuffer.allocate(8).putLong(value).array();
            this.put(cfHandle, this.ableWalWriteOptions, key, key.length, valueBytes, valueBytes.length);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage writeCheckPointForTimer error: {}", (Object)e.getMessage());
        }
    }

    public long getCheckpointForTimer(byte[] columnFamily, byte[] key) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || !COMMON_CHECK_POINT_KEY_SET_FOR_TIMER.contains(key)) {
            logError.error("MessageRocksDBStorage getCheckpointForTimer error, cfHandle: {}, key: {}", (Object)cfHandle, (Object)key);
            return 0L;
        }
        try {
            byte[] checkpoint = this.get(cfHandle, this.readOptions, key);
            if (null == checkpoint && Arrays.equals(key, TIMELINE_CHECK_POINT)) {
                return (System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(10L)) / TimeUnit.SECONDS.toMillis(1L) * TimeUnit.SECONDS.toMillis(1L);
            }
            return checkpoint == null ? 0L : ByteBuffer.wrap(checkpoint).getLong();
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage getCheckpointForTimer error: {}", (Object)e.getMessage());
            return 0L;
        }
    }

    public void deleteCheckPointForTimer(byte[] columnFamily, byte[] key) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || !COMMON_CHECK_POINT_KEY_SET_FOR_TIMER.contains(key)) {
            logError.error("MessageRocksDBStorage deleteCheckPointForTimer error, cfHandle: {}, key: {}", (Object)cfHandle, (Object)key);
            return;
        }
        try {
            this.delete(cfHandle, this.ableWalWriteOptions, key);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage deleteCheckPointForTimer error: {}", (Object)e.getMessage());
            throw new RuntimeException("MessageRocksDBStorage deleteCheckPointForTimer error", e);
        }
    }

    public void writeRecordsForTrans(byte[] columnFamily, List<TransRocksDBRecord> recordList) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || CollectionUtils.isEmpty(recordList)) {
            return;
        }
        long lastOffsetPy = 0L;
        try (WriteBatch writeBatch = new WriteBatch();){
            Long lastOffsetPyStore;
            for (TransRocksDBRecord record : recordList) {
                if (null == record) {
                    logError.error("MessageRocksDBStorage writeRecordsForTrans error, record is null");
                    continue;
                }
                byte[] keyBytes = record.getKeyBytes();
                if (null == keyBytes || keyBytes.length == 0) {
                    logError.error("MessageRocksDBStorage writeRecordsForTrans param error, keyBytes: {}", (Object)keyBytes);
                    continue;
                }
                if (record.isOp()) {
                    writeBatch.delete(cfHandle, record.getKeyBytes());
                    continue;
                }
                byte[] valueBytes = record.getValueBytes();
                if (null == valueBytes || valueBytes.length == 0) {
                    logError.error("MessageRocksDBStorage writeRecordsForTrans param error, valueBytes: {}", (Object)valueBytes);
                    continue;
                }
                writeBatch.put(cfHandle, keyBytes, valueBytes);
                lastOffsetPy = Math.max(lastOffsetPy, record.getOffsetPy());
            }
            if (lastOffsetPy > 0L && (null == (lastOffsetPyStore = this.getLastOffsetPy(columnFamily)) || lastOffsetPy > lastOffsetPyStore)) {
                writeBatch.put(cfHandle, LAST_OFFSET_PY, ByteBuffer.allocate(8).putLong(lastOffsetPy).array());
            }
            this.batchPut(this.ableWalWriteOptions, writeBatch);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage writeRecordsForTrans error: {}", (Object)e.getMessage());
        }
    }

    public void updateRecordsForTrans(byte[] columnFamily, List<TransRocksDBRecord> recordList) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || CollectionUtils.isEmpty(recordList)) {
            return;
        }
        try (WriteBatch writeBatch = new WriteBatch();){
            for (TransRocksDBRecord record : recordList) {
                if (null == record) {
                    logError.error("MessageRocksDBStorage updateRecordsForTrans error, record is null");
                    continue;
                }
                byte[] keyBytes = record.getKeyBytes();
                byte[] valueBytes = record.getValueBytes();
                if (null == keyBytes || keyBytes.length == 0 || null == valueBytes || valueBytes.length == 0) {
                    logError.error("MessageRocksDBStorage updateRecordsForTrans param error, keyBytes: {}, valueBytes: {}", (Object)keyBytes, (Object)valueBytes);
                    continue;
                }
                if (record.isDelete()) {
                    writeBatch.delete(cfHandle, keyBytes);
                    continue;
                }
                writeBatch.put(cfHandle, keyBytes, valueBytes);
            }
            this.batchPut(this.ableWalWriteOptions, writeBatch);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage updateRecordsForTrans error: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TransRocksDBRecord> scanRecordsForTrans(byte[] columnFamily, int size, byte[] startKey) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || size <= 0) {
            return null;
        }
        RocksIterator iterator = null;
        try {
            iterator = this.db.newIterator(cfHandle);
            if (null == startKey || startKey.length == 0) {
                iterator.seekToFirst();
            } else {
                iterator.seek(startKey);
                iterator.next();
            }
            ArrayList<TransRocksDBRecord> records = new ArrayList<TransRocksDBRecord>();
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                if (!(null == key || key.length == 0 || key.length == LAST_OFFSET_PY_LENGTH && Arrays.equals(key, LAST_OFFSET_PY))) {
                    TransRocksDBRecord transRocksDBRecord = null;
                    try {
                        transRocksDBRecord = TransRocksDBRecord.decode(key, iterator.value());
                    }
                    catch (Exception e) {
                        logError.error("MessageRocksDBStorage scanRecordsForTrans error: {}", (Object)e.getMessage());
                    }
                    if (null != transRocksDBRecord) {
                        records.add(transRocksDBRecord);
                    }
                    if (records.size() >= size) break;
                }
                iterator.next();
            }
            ArrayList<TransRocksDBRecord> arrayList = records;
            return arrayList;
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage scanRecordsForTrans error: {}", (Object)e.getMessage());
        }
        finally {
            if (null != iterator) {
                iterator.close();
            }
        }
        return null;
    }

    public TransRocksDBRecord getRecordForTrans(byte[] columnFamily, TransRocksDBRecord transRocksDBRecord) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle || null == transRocksDBRecord) {
            return null;
        }
        try {
            byte[] keyBytes = transRocksDBRecord.getKeyBytes();
            if (null == keyBytes) {
                return null;
            }
            byte[] valueBytes = this.get(cfHandle, this.readOptions, keyBytes);
            if (null == valueBytes || valueBytes.length != 8) {
                return null;
            }
            return TransRocksDBRecord.decode(keyBytes, valueBytes);
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage getRecordForTrans error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public Long getLastOffsetPy(byte[] columnFamily) {
        ColumnFamilyHandle cfHandle = this.getColumnFamily(columnFamily);
        if (null == cfHandle) {
            return null;
        }
        try {
            byte[] offsetBytes = this.get(cfHandle, this.readOptions, LAST_OFFSET_PY);
            return offsetBytes == null ? 0L : ByteBuffer.wrap(offsetBytes).getLong();
        }
        catch (Exception e) {
            logError.error("MessageRocksDBStorage getLastOffsetPy error: {}", (Object)e.getMessage());
            return null;
        }
    }

    public synchronized boolean shutdown() {
        try {
            boolean result = super.shutdown();
            log.info("shutdown MessageRocksDBStorage result: {}", (Object)result);
            return result;
        }
        catch (Exception e) {
            logError.error("shutdown MessageRocksDBStorage error : {}", (Object)e.getMessage());
            return false;
        }
    }

    private ColumnFamilyHandle getColumnFamily(byte[] columnFamily) {
        if (Arrays.equals(columnFamily, RocksDB.DEFAULT_COLUMN_FAMILY)) {
            return this.defaultCFHandle;
        }
        if (Arrays.equals(columnFamily, TIMER_COLUMN_FAMILY)) {
            return this.timerCFHandle;
        }
        if (Arrays.equals(columnFamily, TRANS_COLUMN_FAMILY)) {
            return this.transCFHandle;
        }
        throw new RuntimeException("Unknown column family");
    }

    static {
        Arrays.fill(END_SUFFIX_BYTES, (byte)-1);
        COMMON_CHECK_POINT_KEY_SET_FOR_TIMER = new HashSet<byte[]>();
        SYS_TOPIC_SCAN_OFFSET_CHECK_POINT = "sys_topic_scan_offset_checkpoint".getBytes(StandardCharsets.UTF_8);
        TIMELINE_CHECK_POINT = "timeline_checkpoint".getBytes(StandardCharsets.UTF_8);
        COMMON_CHECK_POINT_KEY_SET_FOR_TIMER.add(SYS_TOPIC_SCAN_OFFSET_CHECK_POINT);
        COMMON_CHECK_POINT_KEY_SET_FOR_TIMER.add(TIMELINE_CHECK_POINT);
        DELETE_VAL_FLAG = new byte[]{-1};
        LAST_OFFSET_PY_LENGTH = LAST_OFFSET_PY.length;
        DELETE_KEY_CACHE_FOR_TIMER = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(60L, TimeUnit.MINUTES).build();
    }
}

