/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.task;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.io.FileIO;
import org.apache.polaris.core.entity.PolarisEntity;
import org.apache.polaris.core.entity.TaskEntity;
import org.apache.polaris.core.persistence.PolarisResolvedPathWrapper;
import org.apache.polaris.core.persistence.ResolvedPolarisEntity;
import org.apache.polaris.core.storage.PolarisStorageActions;
import org.apache.polaris.core.storage.StorageAccessConfig;
import org.apache.polaris.service.catalog.io.FileIOFactory;
import org.apache.polaris.service.catalog.io.StorageAccessConfigProvider;

@RequestScoped
public class TaskFileIOSupplier {
    private final FileIOFactory fileIOFactory;
    private final StorageAccessConfigProvider accessConfigProvider;

    @Inject
    public TaskFileIOSupplier(FileIOFactory fileIOFactory, StorageAccessConfigProvider storageAccessConfigProvider) {
        this.fileIOFactory = fileIOFactory;
        this.accessConfigProvider = storageAccessConfigProvider;
    }

    public FileIO apply(TaskEntity task, TableIdentifier identifier) {
        Map internalProperties = task.getInternalPropertiesAsMap();
        HashMap<String, String> properties = new HashMap<String, String>(internalProperties);
        String location = (String)properties.get("storageLocation");
        Set<String> locations = Set.of(location);
        Set<PolarisStorageActions> storageActions = Set.of(PolarisStorageActions.ALL);
        ResolvedPolarisEntity resolvedTaskEntity = new ResolvedPolarisEntity((PolarisEntity)task, List.of(), List.of());
        PolarisResolvedPathWrapper resolvedPath = new PolarisResolvedPathWrapper(List.of(resolvedTaskEntity));
        StorageAccessConfig storageAccessConfig = this.accessConfigProvider.getStorageAccessConfig(identifier, locations, storageActions, Optional.empty(), resolvedPath);
        String ioImpl = properties.getOrDefault("io-impl", "org.apache.iceberg.io.ResolvingFileIO");
        return this.fileIOFactory.loadFileIO(storageAccessConfig, ioImpl, properties);
    }
}

