/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.service.catalog.api;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.polaris.core.context.RealmContext;
import org.apache.polaris.service.catalog.api.IcebergRestCatalogApiService;
import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.polaris.service.types.NotificationRequest;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/api/catalog/v1/{prefix}")
public class IcebergRestCatalogApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergRestCatalogApi.class);
    private final IcebergRestCatalogApiService service;

    @Inject
    public IcebergRestCatalogApi(IcebergRestCatalogApiService service) {
        this.service = service;
    }

    @POST
    @Path(value="/transactions/commit")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.commitTransaction")
    @Timeout
    public Response commitTransaction(@PathParam(value="prefix") String prefix, CommitTransactionRequest commitTransactionRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"commitTransaction").addKeyValue("prefix", (Object)prefix).addKeyValue("commitTransactionRequest", (Object)String.valueOf(commitTransactionRequest)).log();
        Response ret = this.service.commitTransaction(prefix, commitTransactionRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of commitTransaction API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.createNamespace")
    @Timeout
    public Response createNamespace(@PathParam(value="prefix") String prefix, CreateNamespaceRequest createNamespaceRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"createNamespace").addKeyValue("prefix", (Object)prefix).addKeyValue("createNamespaceRequest", (Object)String.valueOf(createNamespaceRequest)).log();
        Response ret = this.service.createNamespace(prefix, createNamespaceRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createNamespace API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/tables")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.createTable")
    @Timeout
    public Response createTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, CreateTableRequest createTableRequest, @HeaderParam(value="X-Iceberg-Access-Delegation") String xIcebergAccessDelegation, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"createTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("createTableRequest", (Object)String.valueOf(createTableRequest)).log();
        Response ret = this.service.createTable(prefix, namespace, createTableRequest, xIcebergAccessDelegation, realmContext, securityContext);
        LOGGER.debug("Completed execution of createTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/views")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.createView")
    @Timeout
    public Response createView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, CreateViewRequest createViewRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"createView").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("createViewRequest", (Object)String.valueOf(createViewRequest)).log();
        Response ret = this.service.createView(prefix, namespace, createViewRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of createView API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/namespaces/{namespace}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.dropNamespace")
    @Timeout
    public Response dropNamespace(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"dropNamespace").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).log();
        Response ret = this.service.dropNamespace(prefix, namespace, realmContext, securityContext);
        LOGGER.debug("Completed execution of dropNamespace API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.dropTable")
    @Timeout
    public Response dropTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @DefaultValue(value="false") @QueryParam(value="purgeRequested") Boolean purgeRequested, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"dropTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).addKeyValue("purgeRequested", (Object)purgeRequested).log();
        Response ret = this.service.dropTable(prefix, namespace, table, purgeRequested, realmContext, securityContext);
        LOGGER.debug("Completed execution of dropTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @DELETE
    @Path(value="/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.dropView")
    @Timeout
    public Response dropView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"dropView").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("view", (Object)view).log();
        Response ret = this.service.dropView(prefix, namespace, view, realmContext, securityContext);
        LOGGER.debug("Completed execution of dropView API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.listNamespaces")
    @Timeout
    public Response listNamespaces(@PathParam(value="prefix") String prefix, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @QueryParam(value="parent") String parent, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"listNamespaces").addKeyValue("prefix", (Object)prefix).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).addKeyValue("parent", (Object)parent).log();
        Response ret = this.service.listNamespaces(prefix, pageToken, pageSize, parent, realmContext, securityContext);
        LOGGER.debug("Completed execution of listNamespaces API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/tables")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.listTables")
    @Timeout
    public Response listTables(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"listTables").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).log();
        Response ret = this.service.listTables(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        LOGGER.debug("Completed execution of listTables API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/views")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.listViews")
    @Timeout
    public Response listViews(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @QueryParam(value="pageToken") String pageToken, @QueryParam(value="pageSize") Integer pageSize, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"listViews").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("pageToken", (Object)pageToken).addKeyValue("pageSize", (Object)pageSize).log();
        Response ret = this.service.listViews(prefix, namespace, pageToken, pageSize, realmContext, securityContext);
        LOGGER.debug("Completed execution of listViews API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/tables/{table}/credentials")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.loadCredentials")
    @Timeout
    public Response loadCredentials(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"loadCredentials").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).log();
        Response ret = this.service.loadCredentials(prefix, namespace, table, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadCredentials API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.loadNamespaceMetadata")
    @Timeout
    public Response loadNamespaceMetadata(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"loadNamespaceMetadata").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).log();
        Response ret = this.service.loadNamespaceMetadata(prefix, namespace, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadNamespaceMetadata API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.loadTable")
    @Timeout
    public Response loadTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @HeaderParam(value="X-Iceberg-Access-Delegation") String xIcebergAccessDelegation, @HeaderParam(value="If-None-Match") String ifNoneMatch, @QueryParam(value="snapshots") String snapshots, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"loadTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).addKeyValue("snapshots", (Object)snapshots).log();
        Response ret = this.service.loadTable(prefix, namespace, table, xIcebergAccessDelegation, ifNoneMatch, snapshots, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @GET
    @Path(value="/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.loadView")
    @Timeout
    public Response loadView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"loadView").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("view", (Object)view).log();
        Response ret = this.service.loadView(prefix, namespace, view, realmContext, securityContext);
        LOGGER.debug("Completed execution of loadView API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @HEAD
    @Path(value="/namespaces/{namespace}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.namespaceExists")
    @Timeout
    public Response namespaceExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"namespaceExists").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).log();
        Response ret = this.service.namespaceExists(prefix, namespace, realmContext, securityContext);
        LOGGER.debug("Completed execution of namespaceExists API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/register")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.registerTable")
    @Timeout
    public Response registerTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, RegisterTableRequest registerTableRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"registerTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("registerTableRequest", (Object)String.valueOf(registerTableRequest)).log();
        Response ret = this.service.registerTable(prefix, namespace, registerTableRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of registerTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/tables/rename")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.renameTable")
    @Timeout
    public Response renameTable(@PathParam(value="prefix") String prefix, RenameTableRequest renameTableRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"renameTable").addKeyValue("prefix", (Object)prefix).addKeyValue("renameTableRequest", (Object)String.valueOf(renameTableRequest)).log();
        Response ret = this.service.renameTable(prefix, renameTableRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of renameTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/views/rename")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.renameView")
    @Timeout
    public Response renameView(@PathParam(value="prefix") String prefix, RenameTableRequest renameTableRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"renameView").addKeyValue("prefix", (Object)prefix).addKeyValue("renameTableRequest", (Object)String.valueOf(renameTableRequest)).log();
        Response ret = this.service.renameView(prefix, renameTableRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of renameView API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/views/{view}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.replaceView")
    @Timeout
    public Response replaceView(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, CommitViewRequest commitViewRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"replaceView").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("view", (Object)view).addKeyValue("commitViewRequest", (Object)String.valueOf((Object)commitViewRequest)).log();
        Response ret = this.service.replaceView(prefix, namespace, view, commitViewRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of replaceView API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/tables/{table}/metrics")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.reportMetrics")
    @Timeout
    public Response reportMetrics(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, ReportMetricsRequest reportMetricsRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"reportMetrics").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).addKeyValue("reportMetricsRequest", (Object)String.valueOf(reportMetricsRequest)).log();
        Response ret = this.service.reportMetrics(prefix, namespace, table, reportMetricsRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of reportMetrics API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/tables/{table}/notifications")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.sendNotification")
    @Timeout
    public Response sendNotification(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, NotificationRequest notificationRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"sendNotification").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).addKeyValue("notificationRequest", (Object)String.valueOf(notificationRequest)).log();
        Response ret = this.service.sendNotification(prefix, namespace, table, notificationRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of sendNotification API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @HEAD
    @Path(value="/namespaces/{namespace}/tables/{table}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.tableExists")
    @Timeout
    public Response tableExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"tableExists").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).log();
        Response ret = this.service.tableExists(prefix, namespace, table, realmContext, securityContext);
        LOGGER.debug("Completed execution of tableExists API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/properties")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.updateProperties")
    @Timeout
    public Response updateProperties(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"updateProperties").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("updateNamespacePropertiesRequest", (Object)String.valueOf(updateNamespacePropertiesRequest)).log();
        Response ret = this.service.updateProperties(prefix, namespace, updateNamespacePropertiesRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updateProperties API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @POST
    @Path(value="/namespaces/{namespace}/tables/{table}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.updateTable")
    @Timeout
    public Response updateTable(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="table") String table, CommitTableRequest commitTableRequest, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"updateTable").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("table", (Object)table).addKeyValue("commitTableRequest", (Object)String.valueOf((Object)commitTableRequest)).log();
        Response ret = this.service.updateTable(prefix, namespace, table, commitTableRequest, realmContext, securityContext);
        LOGGER.debug("Completed execution of updateTable API with status code {}", (Object)ret.getStatus());
        return ret;
    }

    @HEAD
    @Path(value="/namespaces/{namespace}/views/{view}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"**"})
    @Timed(value="polaris.CatalogApi.viewExists")
    @Timeout
    public Response viewExists(@PathParam(value="prefix") String prefix, @PathParam(value="namespace") String namespace, @PathParam(value="view") String view, @Context @MeterTag(key="realm_id", expression="realmIdentifier") RealmContext realmContext, @Context @MeterTag(key="principal", expression="userPrincipal") SecurityContext securityContext) {
        LOGGER.atDebug().setMessage("Invoking CatalogApi with params").addKeyValue("operation", (Object)"viewExists").addKeyValue("prefix", (Object)prefix).addKeyValue("namespace", (Object)namespace).addKeyValue("view", (Object)view).log();
        Response ret = this.service.viewExists(prefix, namespace, view, realmContext, securityContext);
        LOGGER.debug("Completed execution of viewExists API with status code {}", (Object)ret.getStatus());
        return ret;
    }
}

