/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.RefCnt;

public abstract class AbstractReferenceCountedByteBuf
extends AbstractByteBuf {
    private final RefCnt refCnt = new RefCnt();

    protected AbstractReferenceCountedByteBuf(int maxCapacity) {
        super(maxCapacity);
    }

    @Override
    boolean isAccessible() {
        return RefCnt.isLiveNonVolatile((RefCnt)this.refCnt);
    }

    public int refCnt() {
        return RefCnt.refCnt((RefCnt)this.refCnt);
    }

    protected final void setRefCnt(int count) {
        RefCnt.setRefCnt((RefCnt)this.refCnt, (int)count);
    }

    protected final void resetRefCnt() {
        RefCnt.resetRefCnt((RefCnt)this.refCnt);
    }

    @Override
    public ByteBuf retain() {
        RefCnt.retain((RefCnt)this.refCnt);
        return this;
    }

    @Override
    public ByteBuf retain(int increment) {
        RefCnt.retain((RefCnt)this.refCnt, (int)increment);
        return this;
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object hint) {
        return this;
    }

    public boolean release() {
        return this.handleRelease(RefCnt.release((RefCnt)this.refCnt));
    }

    public boolean release(int decrement) {
        return this.handleRelease(RefCnt.release((RefCnt)this.refCnt, (int)decrement));
    }

    private boolean handleRelease(boolean result) {
        if (result) {
            this.deallocate();
        }
        return result;
    }

    protected abstract void deallocate();
}

