/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.internal;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Flusher
extends IteratingCallback
implements Dumpable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2Flusher.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<WindowEntry> windows = new ArrayDeque<WindowEntry>();
    private final Deque<HTTP2Session.Entry> entries = new ArrayDeque<HTTP2Session.Entry>();
    private final Queue<HTTP2Session.Entry> pendingEntries = new ArrayDeque<HTTP2Session.Entry>();
    private final Collection<HTTP2Session.Entry> processedEntries = new ArrayList<HTTP2Session.Entry>();
    private final HTTP2Session session;
    private final RetainableByteBuffer.Mutable accumulator;
    private Invocable.InvocationType invocationType = Invocable.InvocationType.NON_BLOCKING;
    private Throwable terminated;
    private HTTP2Session.Entry stalledEntry;

    public HTTP2Flusher(HTTP2Session session) {
        HTTP2Connection http2Connection;
        Connection connection;
        this.session = session;
        EndPoint endPoint = session.getEndPoint();
        boolean direct = endPoint != null && (connection = endPoint.getConnection()) instanceof HTTP2Connection && (http2Connection = (HTTP2Connection)connection).isUseOutputDirectByteBuffers();
        this.accumulator = new RetainableByteBuffer.DynamicCapacity(session.getGenerator().getByteBufferPool(), direct, -1L);
    }

    public Invocable.InvocationType getInvocationType() {
        return this.invocationType;
    }

    public void window(HTTP2Stream stream, WindowUpdateFrame frame) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.windows.offer(new WindowEntry(stream, frame));
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    public boolean prepend(HTTP2Session.Entry entry) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                this.entries.offerFirst(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Prepended {}, entries={}", (Object)entry, (Object)this.entries.size());
                }
                boolean bl = true;
                return bl;
            }
        }
        entry.closeAndFail(closed);
        return false;
    }

    public boolean append(HTTP2Session.Entry entry) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            FrameType frameType;
            closed = this.terminated;
            if (closed instanceof HpackException.SessionException && ((frameType = entry.frame().getType()) == FrameType.RST_STREAM || frameType == FrameType.GO_AWAY)) {
                closed = null;
            }
            if (closed == null) {
                this.entries.offer(entry);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, entries={}, {}", new Object[]{entry, this.entries.size(), this});
                }
                boolean bl = true;
                return bl;
            }
        }
        entry.closeAndFail(closed);
        return false;
    }

    public boolean append(List<HTTP2Session.Entry> list) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            if (closed == null) {
                list.forEach(this.entries::offer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Appended {}, entries={} {}", new Object[]{list, this.entries.size(), this});
                }
                boolean bl = true;
                return bl;
            }
        }
        list.forEach(entry -> entry.closeAndFail(closed));
        return false;
    }

    private int getWindowQueueSize() {
        try (AutoLock ignored = this.lock.lock();){
            int n = this.windows.size();
            return n;
        }
    }

    public int getFrameQueueSize() {
        try (AutoLock ignored = this.lock.lock();){
            int n = this.entries.size();
            return n;
        }
    }

    protected IteratingCallback.Action process() throws Throwable {
        block34: {
            int writeThreshold;
            HTTP2Session.Entry entry;
            if (LOG.isDebugEnabled()) {
                LOG.debug("process {} {}", (Object)this.session, (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                WindowEntry windowEntry;
                if (this.terminated != null) {
                    FrameType frameType;
                    boolean rethrow = true;
                    if (this.terminated instanceof HpackException.SessionException && (entry = this.entries.peek()) != null && ((frameType = entry.frame().getType()) == FrameType.RST_STREAM || frameType == FrameType.GO_AWAY)) {
                        rethrow = false;
                        if (frameType == FrameType.GO_AWAY) {
                            this.terminated = new ClosedChannelException().initCause(this.terminated);
                        }
                    }
                    if (rethrow) {
                        throw this.terminated;
                    }
                }
                while ((windowEntry = this.windows.poll()) != null) {
                    windowEntry.perform();
                }
                while ((entry = this.entries.poll()) != null) {
                    this.pendingEntries.offer(entry);
                }
            }
            if (this.pendingEntries.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Flushed {} {}", (Object)this.session, (Object)this);
                }
                return IteratingCallback.Action.IDLE;
            }
            do {
                boolean progress = false;
                if (this.pendingEntries.isEmpty()) break block34;
                Iterator pending = this.pendingEntries.iterator();
                while (pending.hasNext()) {
                    entry = (HTTP2Session.Entry)((Object)pending.next());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing {}", (Object)entry);
                    }
                    if (entry.shouldBeDropped()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dropped {}", (Object)entry);
                        }
                        entry.closeAndFail((Throwable)new EofException("dropped"));
                        pending.remove();
                        continue;
                    }
                    try {
                        if (entry.generate(this.accumulator)) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Generated {} frame bytes for {}", (Object)entry.getFrameBytesGenerated(), (Object)entry);
                            }
                            progress = true;
                            if (!this.processedEntries.contains((Object)entry)) {
                                this.processedEntries.add(entry);
                                this.invocationType = Invocable.combine((Invocable.InvocationType)this.invocationType, (Invocable.InvocationType)Invocable.getInvocationType((Object)entry.getCallback()));
                            }
                            if (entry.getDataBytesRemaining() != 0) continue;
                            pending.remove();
                            continue;
                        }
                        if (this.session.getSendWindow() > 0 || this.stalledEntry != null) continue;
                        this.stalledEntry = entry;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Flow control stalled at {}", (Object)entry);
                    }
                    catch (HpackException.StreamException failure) {
                        if (LOG.isDebugEnabled()) {
                            LOG.atDebug().setCause((Throwable)failure).log("Failure generating {}", (Object)entry);
                        }
                        entry.resetAndFail(failure);
                        pending.remove();
                    }
                    catch (HpackException.SessionException failure) {
                        if (LOG.isDebugEnabled()) {
                            LOG.atDebug().setCause((Throwable)failure).log("Failure generating {}", (Object)entry);
                        }
                        this.onSessionFailure(failure);
                        return IteratingCallback.Action.IDLE;
                    }
                    catch (Throwable failure) {
                        if (LOG.isDebugEnabled()) {
                            LOG.atDebug().setCause(failure).log("Failure generating {}", (Object)entry);
                        }
                        this.failed(failure);
                        return IteratingCallback.Action.SCHEDULED;
                    }
                }
                if (!progress || this.stalledEntry != null) break block34;
                writeThreshold = this.session.getWriteThreshold();
            } while (this.accumulator.size() < (long)writeThreshold);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write threshold {} exceeded", (Object)writeThreshold);
            }
        }
        if (this.accumulator.isEmpty()) {
            this.finish();
            return IteratingCallback.Action.IDLE;
        }
        this.session.notifyOutgoingFrames(this.processedEntries);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Writing {} bytes - entries processed/pending {}/{}: {}/{}", new Object[]{this.accumulator.size(), this.processedEntries.size(), this.pendingEntries.size(), this.processedEntries, this.pendingEntries});
        }
        this.accumulator.writeTo((Content.Sink)this.session.getEndPoint(), false, (Callback)this);
        return IteratingCallback.Action.SCHEDULED;
    }

    protected void onSuccess() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Written - entries processed/pending {}/{}: {}/{}", new Object[]{this.processedEntries.size(), this.pendingEntries.size(), this.processedEntries, this.pendingEntries});
        }
        this.finish();
    }

    private void finish() {
        this.accumulator.clear();
        this.processedEntries.forEach(Callback.Nested::succeeded);
        this.processedEntries.clear();
        this.invocationType = Invocable.InvocationType.NON_BLOCKING;
        if (this.stalledEntry != null) {
            HTTP2Session.Entry entry;
            int size = this.pendingEntries.size();
            for (int i = 0; i < size && (entry = this.pendingEntries.peek()) != this.stalledEntry; ++i) {
                this.pendingEntries.poll();
                this.pendingEntries.offer(entry);
            }
            this.stalledEntry = null;
        }
    }

    protected void onCompleteSuccess() {
        throw new IllegalStateException();
    }

    protected void onFailure(Throwable x) {
        HashSet<HTTP2Session.Entry> allEntries;
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            this.terminated = x;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log(String.format("%s, entries processed/pending/queued=%d/%d/%d", closed != null ? "Closing" : "Failing", this.processedEntries.size(), this.pendingEntries.size(), this.entries.size()));
            }
            allEntries = new HashSet<HTTP2Session.Entry>(this.entries);
            this.entries.clear();
        }
        allEntries.addAll(this.processedEntries);
        this.processedEntries.clear();
        allEntries.addAll(this.pendingEntries);
        this.pendingEntries.clear();
        if (closed == null) {
            this.session.onWriteFailure(x);
        }
        allEntries.forEach(entry -> entry.closeAndFail(x));
    }

    protected void onCompleteFailure(Throwable x) {
        this.accumulator.release();
    }

    private void onSessionFailure(Throwable x) {
        HashSet<HTTP2Session.Entry> allEntries;
        Throwable closed;
        this.accumulator.clear();
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            this.terminated = x;
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(x).log(String.format("%s, entries processed/pending/queued=%d/%d/%d", closed != null ? "Closing" : "Failing", this.processedEntries.size(), this.pendingEntries.size(), this.entries.size()));
            }
            allEntries = new HashSet<HTTP2Session.Entry>(this.entries);
            this.entries.clear();
        }
        allEntries.addAll(this.processedEntries);
        this.processedEntries.clear();
        allEntries.addAll(this.pendingEntries);
        this.pendingEntries.clear();
        allEntries.forEach(entry -> entry.resetAndFail(x));
        if (closed == null) {
            this.session.close(ErrorCode.COMPRESSION_ERROR.code, null, NOOP);
        }
    }

    public void terminate(Throwable cause) {
        Throwable closed;
        try (AutoLock ignored = this.lock.lock();){
            closed = this.terminated;
            this.terminated = cause;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} {}", (Object)(closed != null ? "Terminated" : "Terminating"), (Object)this);
            }
        }
        if (closed == null) {
            this.iterate();
        }
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }

    public String toString() {
        try (AutoLock ignored = this.lock.tryLock();){
            String held = this.lock.isHeldByCurrentThread() ? "" : "?";
            String string = String.format("%s[%s:windowQueue=%d,frameQueue=%d,processed/pending=%d/%d]", super.toString(), held, this.windows.size(), this.entries.size(), this.processedEntries.size(), this.pendingEntries.size());
            return string;
        }
    }

    private class WindowEntry {
        private final HTTP2Stream stream;
        private final WindowUpdateFrame frame;

        public WindowEntry(HTTP2Stream stream, WindowUpdateFrame frame) {
            this.stream = stream;
            this.frame = frame;
        }

        public void perform() {
            FlowControlStrategy flowControl = HTTP2Flusher.this.session.getFlowControlStrategy();
            flowControl.onWindowUpdate(HTTP2Flusher.this.session, this.stream, this.frame);
        }
    }
}

