/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static String toLowerCase(String source) {
        return source.toLowerCase(Locale.US);
    }

    public static String toUpperCase(String source) {
        return source.toUpperCase(Locale.US);
    }

    public static int indexOfIgnoreCase(String text, String str) {
        return StringUtils.indexOfIgnoreCase(text, str, 0);
    }

    public static int indexOfIgnoreCase(String text, String str, int startIndex) {
        Matcher m = Pattern.compile(Pattern.quote(str), 2).matcher(text);
        return m.find(startIndex) ? m.start() : -1;
    }

    public static final class DamerauLevenshteinDistance {
        private final int INF;
        private final int[][] h;
        private final String a;
        private final String b;
        private static final int Wi = 1;
        private static final int Wd = 1;
        private static final int Wc = 1;
        private static final int Ws = 1;
        private int[] smallDA;
        private Map<Character, Integer> bigDA;

        public static int of(String a, String b) {
            return new DamerauLevenshteinDistance(a, b).calculate();
        }

        private int calculate() {
            int i;
            for (i = 0; i <= this.a.length(); ++i) {
                this.h(i, 0, i * 1);
                this.h(i, -1, this.INF);
            }
            for (int j = 0; j <= this.b.length(); ++j) {
                this.h(0, j, j * 1);
                this.h(-1, j, this.INF);
            }
            for (i = 1; i <= this.a.length(); ++i) {
                int db = 0;
                for (int j = 1; j <= this.b.length(); ++j) {
                    int d;
                    int i1 = this.da(this.characterAt(this.b, j));
                    int j1 = db;
                    boolean eq = this.characterAt(this.a, i) == this.characterAt(this.b, j);
                    int n = d = eq ? 0 : 1;
                    if (eq) {
                        db = j;
                    }
                    int m = DamerauLevenshteinDistance.min(this.h(i - 1, j - 1) + d, this.h(i, j - 1) + 1, this.h(i - 1, j) + 1, this.h(i1 - 1, j1 - 1) + (i - i1 - 1) * 1 + 1 + (j - j1 - 1) * 1);
                    this.h(i, j, m);
                }
                this.da(this.characterAt(this.a, i), i);
            }
            return this.h(this.a.length(), this.b.length());
        }

        private int characterAt(String s, int i) {
            return s.charAt(i - 1);
        }

        private void h(int i, int j, int value) {
            this.h[i + 1][j + 1] = value;
        }

        private int h(int i, int j) {
            return this.h[i + 1][j + 1];
        }

        private int da(int i) {
            if (this.smallDA != null && i < 128) {
                return this.smallDA[i];
            }
            if (this.bigDA != null) {
                Integer v = this.bigDA.get(Character.valueOf((char)i));
                return v == null ? 0 : v;
            }
            return 0;
        }

        private void da(int i, int value) {
            if (this.bigDA == null && i < 128) {
                if (this.smallDA == null) {
                    this.smallDA = new int[127];
                }
                this.smallDA[i] = value;
            } else {
                if (this.bigDA == null) {
                    this.bigDA = new HashMap<Character, Integer>();
                    if (this.smallDA != null) {
                        for (int j = 0; j < this.smallDA.length; ++j) {
                            int v = this.smallDA[j];
                            if (v == 0) continue;
                            this.bigDA.put(Character.valueOf((char)j), v);
                        }
                        this.smallDA = null;
                    }
                }
                this.bigDA.put(Character.valueOf((char)i), value);
            }
            assert (this.smallDA == null ^ this.bigDA == null);
        }

        private static int min(int a, int b, int c, int d) {
            return Math.min(a, Math.min(b, Math.min(c, d)));
        }

        private DamerauLevenshteinDistance(String a, String b) {
            this.a = a;
            this.b = b;
            this.h = new int[this.a.length() + 2][this.b.length() + 2];
            this.INF = this.a.length() * 1 + this.b.length() * 1 + 1;
            if (this.INF < 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }
}

