/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.comp;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.tools.javac.code.DeferredCompletionFailureHandler;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.code.TypeTag;
import jpt.sun.tools.javac.code.Types;
import jpt.sun.tools.javac.comp.Annotate;
import jpt.sun.tools.javac.comp.ArgumentAttr;
import jpt.sun.tools.javac.comp.Attr;
import jpt.sun.tools.javac.comp.AttrContext;
import jpt.sun.tools.javac.comp.Check;
import jpt.sun.tools.javac.comp.Enter;
import jpt.sun.tools.javac.comp.Env;
import jpt.sun.tools.javac.comp.Flow;
import jpt.sun.tools.javac.comp.Infer;
import jpt.sun.tools.javac.comp.InferenceContext;
import jpt.sun.tools.javac.comp.Resolve;
import jpt.sun.tools.javac.comp.TypeEnvs;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.tree.JCTree;
import jpt.sun.tools.javac.tree.TreeCopier;
import jpt.sun.tools.javac.tree.TreeInfo;
import jpt.sun.tools.javac.tree.TreeMaker;
import jpt.sun.tools.javac.tree.TreeScanner;
import jpt.sun.tools.javac.util.Assert;
import jpt.sun.tools.javac.util.Context;
import jpt.sun.tools.javac.util.GraphUtils;
import jpt.sun.tools.javac.util.JCDiagnostic;
import jpt.sun.tools.javac.util.List;
import jpt.sun.tools.javac.util.ListBuffer;
import jpt.sun.tools.javac.util.Log;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;
import jpt.sun.tools.javac.util.Warner;

public class DeferredAttr
extends JCTree.Visitor {
    protected static final Context.Key<DeferredAttr> deferredAttrKey = new Context.Key();
    final Annotate annotate;
    final Attr attr;
    final ArgumentAttr argumentAttr;
    final Check chk;
    final JCDiagnostic.Factory diags;
    final Enter enter;
    final Infer infer;
    final Resolve rs;
    final Log log;
    final Symtab syms;
    final TreeMaker make;
    final TreeCopier<Void> treeCopier;
    final Types.TypeMapping<Void> deferredCopier;
    final Types types;
    final Flow flow;
    final Names names;
    final TypeEnvs typeEnvs;
    final DeferredCompletionFailureHandler dcfh;
    final JCTree stuckTree;
    DeferredStuckPolicy dummyStuckPolicy = new DeferredStuckPolicy(){

        @Override
        public boolean isStuck() {
            return false;
        }

        @Override
        public Set<Type> stuckVars() {
            return Collections.emptySet();
        }

        @Override
        public Set<Type> depVars() {
            return Collections.emptySet();
        }
    };
    final DeferredAttrContext emptyDeferredAttrContext;

    public static DeferredAttr instance(Context context) {
        DeferredAttr instance = context.get(deferredAttrKey);
        if (instance == null) {
            instance = new DeferredAttr(context);
        }
        return instance;
    }

    protected DeferredAttr(Context context) {
        context.put(deferredAttrKey, this);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.chk = Check.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.enter = Enter.instance(context);
        this.infer = Infer.instance(context);
        this.rs = Resolve.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.types = Types.instance(context);
        this.flow = Flow.instance(context);
        this.names = Names.instance(context);
        this.stuckTree = this.make.Ident(this.names.empty).setType(Type.stuckType);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dcfh = DeferredCompletionFailureHandler.instance(context);
        this.emptyDeferredAttrContext = new DeferredAttrContext(AttrMode.CHECK, null, Resolve.MethodResolutionPhase.BOX, this.infer.emptyContext, null, null){

            @Override
            void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo ri, DeferredStuckPolicy deferredStuckPolicy) {
                Assert.error("Empty deferred context!");
            }

            @Override
            void complete() {
                Assert.error("Empty deferred context!");
            }

            public String toString() {
                return "Empty deferred context!";
            }
        };
        this.treeCopier = new TreeCopier<Void>(this.make){

            @Override
            public JCTree visitNewClass(NewClassTree node, Void p) {
                JCTree.JCNewClass t = (JCTree.JCNewClass)node;
                if (TreeInfo.isDiamond(t)) {
                    JCTree.JCExpression encl = this.copy(t.encl, p);
                    List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
                    JCTree.JCExpression clazz = this.copy(t.clazz, p);
                    List<JCTree.JCExpression> args = this.copy(t.args, p);
                    JCTree.JCClassDecl def = null;
                    return DeferredAttr.this.make.at(t.pos).SpeculativeNewClass(encl, typeargs, clazz, args, def, t.def != null || t.classDeclRemoved());
                }
                return super.visitNewClass(node, p);
            }

            @Override
            public JCTree visitMemberReference(MemberReferenceTree node, Void p) {
                final JCTree.JCMemberReference t = (JCTree.JCMemberReference)node;
                JCTree.JCExpression expr = this.copy(t.expr, p);
                List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
                JCTree.JCMemberReference result = new JCTree.JCMemberReference(t.mode, t.name, expr, typeargs){

                    @Override
                    public void setOverloadKind(JCTree.JCMemberReference.OverloadKind overloadKind) {
                        JCTree.JCMemberReference.OverloadKind previous = t.getOverloadKind();
                        if (previous == null || previous == JCTree.JCMemberReference.OverloadKind.ERROR) {
                            t.setOverloadKind(overloadKind);
                        } else {
                            Assert.check(previous == overloadKind || overloadKind == JCTree.JCMemberReference.OverloadKind.ERROR);
                        }
                    }

                    @Override
                    public JCTree.JCMemberReference.OverloadKind getOverloadKind() {
                        return t.getOverloadKind();
                    }
                };
                result.pos = t.pos;
                return result;
            }
        };
        this.deferredCopier = new Types.TypeMapping<Void>(){

            @Override
            public Type visitType(Type t, Void v) {
                if (t.hasTag(TypeTag.DEFERRED)) {
                    DeferredType dt = (DeferredType)t;
                    return new DeferredType(DeferredAttr.this.treeCopier.copy(dt.tree), dt.env);
                }
                return t;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCTree.JCLambda attribSpeculativeLambda(JCTree.JCLambda that, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        ListBuffer<JCTree.JCStatement> stats = new ListBuffer<JCTree.JCStatement>();
        stats.addAll((Collection<JCTree.JCStatement>)that.params);
        if (that.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
            stats.add(this.make.Return((JCTree.JCExpression)that.body));
        } else {
            stats.add((JCTree.JCBlock)that.body);
        }
        JCTree.JCBlock lambdaBlock = this.make.at(that.pos).Block(0L, stats.toList());
        Env<AttrContext> localEnv = this.attr.lambdaEnv(that, env);
        try {
            ((AttrContext)localEnv.info).returnResult = resultInfo;
            JCTree.JCBlock speculativeTree = (JCTree.JCBlock)this.attribSpeculative(lambdaBlock, localEnv, resultInfo);
            List<JCTree.JCVariableDecl> args = speculativeTree.getStatements().stream().filter(s -> s.hasTag(JCTree.Tag.VARDEF)).map(t -> (JCTree.JCVariableDecl)t).collect(List.collector());
            JCTree lambdaBody = (JCTree)((List)speculativeTree.getStatements()).last();
            if (lambdaBody.hasTag(JCTree.Tag.RETURN)) {
                lambdaBody = ((JCTree.JCReturn)lambdaBody).expr;
            }
            JCTree.JCLambda speculativeLambda = this.make.Lambda(args, lambdaBody);
            this.attr.preFlow(speculativeLambda);
            this.flow.analyzeLambda(env, speculativeLambda, this.make, false);
            JCTree.JCLambda jCLambda = speculativeLambda;
            return jCLambda;
        }
        finally {
            ((AttrContext)localEnv.info).scope.leave();
        }
    }

    JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo) {
        return this.attribSpeculative(tree, env, resultInfo, this.treeCopier, null, AttributionMode.SPECULATIVE, !this.hasTypeDeclaration(tree) ? null : this.argumentAttr.withLocalCacheContext());
    }

    private boolean hasTypeDeclaration(JCTree tree) {
        TypeDeclVisitor typeDeclVisitor = new TypeDeclVisitor();
        typeDeclVisitor.scan(tree);
        return typeDeclVisitor.result;
    }

    JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo, ArgumentAttr.LocalCacheContext localCache) {
        return this.attribSpeculative(tree, env, resultInfo, this.treeCopier, null, AttributionMode.SPECULATIVE, localCache);
    }

    <Z> JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo, TreeCopier<Z> deferredCopier, Supplier<Log.DiagnosticHandler> diagHandlerCreator, AttributionMode attributionMode, ArgumentAttr.LocalCacheContext localCache) {
        JCTree newTree = deferredCopier.copy(tree);
        return this.attribSpeculative(newTree, env, resultInfo, diagHandlerCreator, attributionMode, localCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <Z> JCTree attribSpeculative(JCTree tree, Env<AttrContext> env, Attr.ResultInfo resultInfo, Supplier<Log.DiagnosticHandler> diagHandlerCreator, AttributionMode attributionMode, ArgumentAttr.LocalCacheContext localCache) {
        Env<AttrContext> speculativeEnv = env.dup(tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(((AttrContext)env.info).scope.owner)));
        ((AttrContext)speculativeEnv.info).attributionMode = attributionMode;
        Log.DiagnosticHandler deferredDiagnosticHandler = diagHandlerCreator != null ? diagHandlerCreator.get() : new DeferredAttrDiagHandler(this.log, tree);
        DeferredCompletionFailureHandler.Handler prevCFHandler = this.dcfh.setHandler(this.dcfh.speculativeCodeHandler);
        Annotate.Queues prevQueues = this.annotate.setQueues(new Annotate.Queues());
        int nwarnings = this.log.nwarnings;
        this.log.nwarnings = 0;
        try {
            this.attr.attribTree(tree, speculativeEnv, resultInfo);
            JCTree jCTree = tree;
            return jCTree;
        }
        finally {
            this.annotate.setQueues(prevQueues);
            this.dcfh.setHandler(prevCFHandler);
            this.log.nwarnings += nwarnings;
            this.enter.unenter(env.toplevel, tree);
            this.log.popDiagnosticHandler(deferredDiagnosticHandler);
            if (localCache != null) {
                localCache.leave();
            }
        }
    }

    static interface DeferredStuckPolicy {
        public boolean isStuck();

        public Set<Type> stuckVars();

        public Set<Type> depVars();
    }

    public static enum AttrMode {
        SPECULATIVE,
        CHECK;

    }

    class DeferredAttrContext {
        final AttrMode mode;
        final Symbol msym;
        final Resolve.MethodResolutionPhase phase;
        final InferenceContext inferenceContext;
        final DeferredAttrContext parent;
        final Warner warn;
        ArrayList<DeferredAttrNode> deferredAttrNodes = new ArrayList();

        DeferredAttrContext(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase, InferenceContext inferenceContext, DeferredAttrContext parent, Warner warn) {
            this.mode = mode;
            this.msym = msym;
            this.phase = phase;
            this.parent = parent;
            this.warn = warn;
            this.inferenceContext = inferenceContext;
        }

        void addDeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.deferredAttrNodes.add(new DeferredAttrNode(dt, resultInfo, deferredStuckPolicy));
        }

        void complete() {
            while (!this.deferredAttrNodes.isEmpty()) {
                boolean progress = false;
                for (DeferredAttrNode deferredAttrNode : List.from(this.deferredAttrNodes)) {
                    if (!deferredAttrNode.process(this)) continue;
                    this.deferredAttrNodes.remove(deferredAttrNode);
                    progress = true;
                }
                if (progress) continue;
                if (this.insideOverloadPhase()) {
                    for (DeferredAttrNode deferredNode : this.deferredAttrNodes) {
                        deferredNode.dt.tree.type = Type.noType;
                    }
                    return;
                }
                try {
                    DeferredAttrNode toUnstuck = this.pickDeferredNode();
                    this.inferenceContext.solveAny(List.from(toUnstuck.deferredStuckPolicy.stuckVars()), this.warn);
                    this.inferenceContext.notifyChange();
                }
                catch (Infer.GraphStrategy.NodeNotFoundException ex) {
                    break;
                }
            }
        }

        public boolean insideOverloadPhase() {
            DeferredAttrContext dac = this;
            if (dac == DeferredAttr.this.emptyDeferredAttrContext) {
                return false;
            }
            if (dac.mode == AttrMode.SPECULATIVE) {
                return true;
            }
            return dac.parent.insideOverloadPhase();
        }

        DeferredAttrNode pickDeferredNode() {
            List<StuckNode> stuckGraph = this.buildStuckGraph();
            List<StuckNode> csn = GraphUtils.tarjan(stuckGraph).get(0);
            return csn.length() == 1 ? (DeferredAttrNode)csn.get((int)0).data : this.deferredAttrNodes.get(0);
        }

        List<StuckNode> buildStuckGraph() {
            DeferredAttr.this.infer.doIncorporation(this.inferenceContext, this.warn);
            Infer infer = DeferredAttr.this.infer;
            Objects.requireNonNull(infer);
            Infer.GraphSolver.InferenceGraph graph = new Infer.GraphSolver.InferenceGraph(new Infer.GraphSolver(infer, this.inferenceContext, DeferredAttr.this.types.noWarnings));
            List<StuckNode> nodes = this.deferredAttrNodes.stream().map(x$0 -> new StuckNode((DeferredAttrNode)x$0)).collect(List.collector());
            for (StuckNode sn1 : nodes) {
                for (StuckNode sn2 : nodes) {
                    if (sn1 == sn2 || !this.canInfluence(graph, sn2, sn1)) continue;
                    sn1.deps.add(sn2);
                }
            }
            return nodes;
        }

        boolean canInfluence(Infer.GraphSolver.InferenceGraph graph, StuckNode sn1, StuckNode sn2) {
            Set<Type> outputVars = ((DeferredAttrNode)sn1.data).deferredStuckPolicy.depVars();
            for (Type inputVar : ((DeferredAttrNode)sn2.data).deferredStuckPolicy.stuckVars()) {
                Infer.GraphSolver.InferenceGraph.Node inputNode = graph.findNode(inputVar);
                if (inputNode == null) continue;
                Set<Infer.GraphSolver.InferenceGraph.Node> inputClosure = inputNode.closure();
                if (!outputVars.stream().map(graph::findNode).anyMatch(inputClosure::contains)) continue;
                return true;
            }
            return false;
        }

        class StuckNode
        extends GraphUtils.TarjanNode<DeferredAttrNode, StuckNode> {
            Set<StuckNode> deps;

            StuckNode(DeferredAttrNode data) {
                super(data);
                this.deps = new HashSet<StuckNode>();
            }

            @Override
            public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                return new GraphUtils.DependencyKind[]{Infer.DependencyKind.STUCK};
            }

            @Override
            public Collection<? extends StuckNode> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                if (dk == Infer.DependencyKind.STUCK) {
                    return this.deps;
                }
                throw new IllegalStateException();
            }

            @Override
            public Iterable<? extends StuckNode> getAllDependencies() {
                return this.deps;
            }
        }
    }

    static enum AttributionMode {
        FULL(false, true),
        ATTRIB_TO_TREE(true, true),
        ANALYZER(true, false),
        SPECULATIVE(true, false);

        final boolean isSpeculative;
        final boolean recover;

        private AttributionMode(boolean isSpeculative, boolean recover) {
            this.isSpeculative = isSpeculative;
            this.recover = recover;
        }

        boolean isSpeculative() {
            return this.isSpeculative;
        }

        boolean recover() {
            return this.recover;
        }
    }

    private static class TypeDeclVisitor
    extends TreeScanner {
        boolean result = false;

        private TypeDeclVisitor() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl that) {
            this.result = true;
        }
    }

    static class DeferredAttrDiagHandler
    extends Log.DeferredDiagnosticHandler {
        DeferredAttrDiagHandler(Log log, JCTree newTree) {
            Log log2 = log;
            Objects.requireNonNull(log2);
            super(log2, (JCDiagnostic d) -> {
                PosScanner posScanner = new PosScanner(d.getDiagnosticPosition());
                posScanner.scan(newTree);
                return posScanner.found;
            });
        }

        static class PosScanner
        extends TreeScanner {
            JCDiagnostic.DiagnosticPosition pos;
            boolean found = false;

            PosScanner(JCDiagnostic.DiagnosticPosition pos) {
                this.pos = pos;
            }

            @Override
            public void scan(JCTree tree) {
                if (tree != null && tree.pos() == this.pos) {
                    this.found = true;
                }
                super.scan(tree);
            }
        }
    }

    class OverloadStuckPolicy
    extends CheckStuckPolicy
    implements DeferredStuckPolicy {
        boolean stuck;

        @Override
        public boolean isStuck() {
            return super.isStuck() || this.stuck;
        }

        public OverloadStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            super(resultInfo, dt);
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            super.visitLambda(tree);
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                this.stuck = true;
            }
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            super.visitReference(tree);
            if (tree.getOverloadKind() != JCTree.JCMemberReference.OverloadKind.UNOVERLOADED) {
                this.stuck = true;
            }
        }
    }

    class CheckStuckPolicy
    extends PolyScanner
    implements DeferredStuckPolicy,
    Infer.FreeTypeListener {
        Type pt;
        InferenceContext inferenceContext;
        Set<Type> stuckVars = new LinkedHashSet<Type>();
        Set<Type> depVars = new LinkedHashSet<Type>();

        @Override
        public boolean isStuck() {
            return !this.stuckVars.isEmpty();
        }

        @Override
        public Set<Type> stuckVars() {
            return this.stuckVars;
        }

        @Override
        public Set<Type> depVars() {
            return this.depVars;
        }

        public CheckStuckPolicy(Attr.ResultInfo resultInfo, DeferredType dt) {
            this.pt = resultInfo.pt;
            this.inferenceContext = resultInfo.checkContext.inferenceContext();
            this.scan(dt.tree);
            if (!this.stuckVars.isEmpty()) {
                resultInfo.checkContext.inferenceContext().addFreeTypeListener(List.from(this.stuckVars), this);
            }
        }

        @Override
        public void typesInferred(InferenceContext inferenceContext) {
            this.stuckVars.clear();
        }

        @Override
        public void visitLambda(JCTree.JCLambda tree) {
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (tree.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT && freeArgVars.nonEmpty()) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getThrownTypes()));
            }
            this.scanLambdaBody(tree, descType.getReturnType());
        }

        @Override
        public void visitReference(JCTree.JCMemberReference tree) {
            this.scan(tree.expr);
            if (this.inferenceContext.inferenceVars().contains(this.pt)) {
                this.stuckVars.add(this.pt);
                return;
            }
            if (!DeferredAttr.this.types.isFunctionalInterface(this.pt)) {
                return;
            }
            Type descType = DeferredAttr.this.types.findDescriptorType(this.pt);
            List<Type> freeArgVars = this.inferenceContext.freeVarsIn(descType.getParameterTypes());
            if (freeArgVars.nonEmpty() && tree.getOverloadKind() != JCTree.JCMemberReference.OverloadKind.UNOVERLOADED) {
                this.stuckVars.addAll(freeArgVars);
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getReturnType()));
                this.depVars.addAll(this.inferenceContext.freeVarsIn(descType.getThrownTypes()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void scanLambdaBody(JCTree.JCLambda lambda, final Type pt) {
            if (lambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                Type prevPt = this.pt;
                try {
                    this.pt = pt;
                    this.scan(lambda.body);
                }
                finally {
                    this.pt = prevPt;
                }
            } else {
                LambdaReturnScanner lambdaScanner = new LambdaReturnScanner(){

                    @Override
                    public void visitReturn(JCTree.JCReturn tree) {
                        if (tree.expr != null) {
                            Type prevPt = CheckStuckPolicy.this.pt;
                            try {
                                CheckStuckPolicy.this.pt = pt;
                                CheckStuckPolicy.this.scan(tree.expr);
                            }
                            finally {
                                CheckStuckPolicy.this.pt = prevPt;
                            }
                        }
                    }
                };
                lambdaScanner.scan(lambda.body);
            }
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression expr) {
            SwitchExpressionScanner switchScanner = new SwitchExpressionScanner(){

                @Override
                public void visitYield(JCTree.JCYield tree) {
                    Type prevPt = CheckStuckPolicy.this.pt;
                    try {
                        CheckStuckPolicy.this.pt = CheckStuckPolicy.this.pt;
                        CheckStuckPolicy.this.scan(tree.value);
                    }
                    finally {
                        CheckStuckPolicy.this.pt = prevPt;
                    }
                }
            };
            switchScanner.scan(expr.cases);
        }
    }

    static class SwitchExpressionScanner
    extends FilterScanner {
        SwitchExpressionScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.IF, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP, JCTree.Tag.YIELD}));
        }
    }

    static class LambdaReturnScanner
    extends FilterScanner {
        LambdaReturnScanner() {
            super(EnumSet.of(JCTree.Tag.BLOCK, new JCTree.Tag[]{JCTree.Tag.CASE, JCTree.Tag.CATCH, JCTree.Tag.DOLOOP, JCTree.Tag.FOREACHLOOP, JCTree.Tag.FORLOOP, JCTree.Tag.IF, JCTree.Tag.RETURN, JCTree.Tag.SYNCHRONIZED, JCTree.Tag.SWITCH, JCTree.Tag.TRY, JCTree.Tag.WHILELOOP}));
        }
    }

    static class PolyScanner
    extends FilterScanner {
        PolyScanner() {
            super(EnumSet.of(JCTree.Tag.CONDEXPR, JCTree.Tag.PARENS, JCTree.Tag.LAMBDA, JCTree.Tag.REFERENCE, JCTree.Tag.SWITCH_EXPRESSION));
        }
    }

    static abstract class FilterScanner
    extends TreeScanner {
        final Predicate<JCTree> treeFilter = t -> validTags.contains((Object)t.getTag());

        FilterScanner(Set<JCTree.Tag> validTags) {
        }

        @Override
        public void scan(JCTree tree) {
            if (tree != null) {
                if (this.treeFilter.test(tree)) {
                    super.scan(tree);
                } else {
                    this.skip(tree);
                }
            }
        }

        void skip(JCTree tree) {
        }
    }

    public class RecoveryDeferredTypeMap
    extends DeferredTypeMap<Type> {
        public RecoveryDeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            super(mode, msym, phase != null ? phase : Resolve.MethodResolutionPhase.BOX);
        }

        @Override
        protected Type typeOf(DeferredType dt, Type pt) {
            Type owntype = super.typeOf(dt, pt);
            return owntype == Type.noType ? this.recover(dt, pt) : owntype;
        }

        @Override
        public Type visitMethodType(Type.MethodType t, Type pt) {
            if (t.hasTag(TypeTag.METHOD) && this.deferredAttrContext.mode == AttrMode.CHECK) {
                Type mtype = this.deferredAttrContext.msym.type;
                Type type = mtype = mtype.hasTag(TypeTag.ERROR) ? ((Type.ErrorType)mtype).getOriginalType() : null;
                if (mtype != null && mtype.hasTag(TypeTag.METHOD)) {
                    List<Type> argtypes1 = this.map((List<Type>)t.getParameterTypes(), mtype.getParameterTypes());
                    Type restype1 = (Type)this.visit(t.getReturnType(), mtype.getReturnType());
                    List<Type> thrown1 = this.map((List<Type>)t.getThrownTypes(), mtype.getThrownTypes());
                    if (argtypes1 == t.getParameterTypes() && restype1 == t.getReturnType() && thrown1 == t.getThrownTypes()) {
                        return t;
                    }
                    return new Type.MethodType(argtypes1, restype1, thrown1, t.tsym);
                }
            }
            return super.visitMethodType(t, pt);
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        private Type recover(DeferredType dt, Type pt) {
            block2: {
                v0 = isLambdaOrMemberRef = dt.tree.hasTag(JCTree.Tag.REFERENCE) != false || dt.tree.hasTag(JCTree.Tag.LAMBDA) != false;
                if (pt == null) ** GOTO lbl-1000
                if (!(dt instanceof ArgumentAttr.ArgumentType)) break block2;
                at = (ArgumentAttr.ArgumentType)dt;
                if (at.speculativeTypes.values().stream().allMatch((Predicate<Type>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$recover$0(jpt.sun.tools.javac.code.Type ), (Ljpt/sun/tools/javac/code/Type;)Z)())) ** GOTO lbl-1000
            }
            if (isLambdaOrMemberRef && !DeferredAttr.this.types.isFunctionalInterface(pt)) lbl-1000:
            // 3 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            needsRecoveryType = v1;
            ptRecovery /* !! */  = needsRecoveryType != false ? Type.recoveryType : pt;
            v2 = DeferredAttr.this.attr;
            Objects.requireNonNull(v2);
            dt.check(new Attr.RecoveryInfo(v2, this.deferredAttrContext, ptRecovery /* !! */ ){
                {
                    Attr attr = x0;
                    Objects.requireNonNull(attr);
                    super(deferredAttrContext, pt);
                }

                @Override
                protected Type check(JCDiagnostic.DiagnosticPosition pos, Type found) {
                    return DeferredAttr.this.chk.checkNonVoid(pos, super.check(pos, found));
                }
            });
            return super.visit(dt);
        }

        private List<Type> map(List<Type> ts, List<Type> pts) {
            if (ts.nonEmpty()) {
                List<Type> tail1 = this.map(ts.tail, pts != null ? pts.tail : null);
                Type t = (Type)this.visit((Type)ts.head, pts != null && pts.nonEmpty() ? (Type)pts.head : null);
                if (tail1 != ts.tail || t != ts.head) {
                    return tail1.prepend(t);
                }
            }
            return ts;
        }

        private static /* synthetic */ boolean lambda$recover$0(Type type) {
            return type.hasTag(TypeTag.ERROR);
        }
    }

    class DeferredTypeMap<T>
    extends Type.StructuralTypeMapping<T> {
        DeferredAttrContext deferredAttrContext;

        protected DeferredTypeMap(AttrMode mode, Symbol msym, Resolve.MethodResolutionPhase phase) {
            this.deferredAttrContext = new DeferredAttrContext(mode, msym, phase, DeferredAttr.this.infer.emptyContext, DeferredAttr.this.emptyDeferredAttrContext, DeferredAttr.this.types.noWarnings);
        }

        @Override
        public Type visitType(Type t, T p) {
            if (!t.hasTag(TypeTag.DEFERRED)) {
                return super.visitType(t, p);
            }
            DeferredType dt = (DeferredType)t;
            return this.typeOf(dt, p);
        }

        protected Type typeOf(DeferredType dt, T p) {
            switch (this.deferredAttrContext.mode.ordinal()) {
                case 1: {
                    return dt.tree.type == null ? Type.noType : dt.tree.type;
                }
                case 0: {
                    return dt.speculativeType(this.deferredAttrContext.msym, this.deferredAttrContext.phase);
                }
            }
            Assert.error();
            return null;
        }
    }

    class DeferredAttrNode {
        DeferredType dt;
        Attr.ResultInfo resultInfo;
        DeferredStuckPolicy deferredStuckPolicy;

        DeferredAttrNode(DeferredType dt, Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            this.dt = dt;
            this.resultInfo = resultInfo;
            this.deferredStuckPolicy = deferredStuckPolicy;
        }

        boolean process(final DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode.ordinal()) {
                case 0: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        new StructuralStuckChecker().check(this.dt, this.resultInfo, deferredAttrContext);
                        return true;
                    }
                    Assert.error("Cannot get here");
                }
                case 1: {
                    if (this.deferredStuckPolicy.isStuck()) {
                        if (deferredAttrContext.parent != DeferredAttr.this.emptyDeferredAttrContext && Type.containsAny(deferredAttrContext.parent.inferenceContext.inferencevars, List.from(this.deferredStuckPolicy.stuckVars()))) {
                            deferredAttrContext.parent.addDeferredAttrNode(this.dt, this.resultInfo.dup(new Check.NestedCheckContext(this.resultInfo.checkContext){

                                @Override
                                public InferenceContext inferenceContext() {
                                    return deferredAttrContext.parent.inferenceContext;
                                }

                                @Override
                                public DeferredAttrContext deferredAttrContext() {
                                    return deferredAttrContext.parent;
                                }
                            }), this.deferredStuckPolicy);
                            this.dt.tree.type = Type.stuckType;
                            return true;
                        }
                        return false;
                    }
                    Assert.check(!deferredAttrContext.insideOverloadPhase(), "attribution shouldn't be happening here");
                    Attr.ResultInfo instResultInfo = this.resultInfo.dup(deferredAttrContext.inferenceContext.asInstType(this.resultInfo.pt));
                    this.dt.check(instResultInfo, DeferredAttr.this.dummyStuckPolicy);
                    return true;
                }
            }
            throw new AssertionError((Object)"Bad mode");
        }

        class StructuralStuckChecker
        extends TreeScanner {
            Attr.ResultInfo resultInfo;
            InferenceContext inferenceContext;
            Env<AttrContext> env;

            StructuralStuckChecker() {
            }

            public void check(DeferredType dt, Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
                this.resultInfo = resultInfo;
                this.inferenceContext = deferredAttrContext.inferenceContext;
                this.env = dt.env;
                dt.tree.accept(this);
                dt.speculativeCache.put(DeferredAttr.this.stuckTree, resultInfo);
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    Type descriptorType = null;
                    try {
                        descriptorType = DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    if (descriptorType.getParameterTypes().length() != tree.params.length()) {
                        checkContext.report(tree, DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleArgTypesInLambda));
                    }
                    Type currentReturnType = descriptorType.getReturnType();
                    boolean returnTypeIsVoid = currentReturnType.hasTag(TypeTag.VOID);
                    if (tree.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                        boolean isExpressionCompatible;
                        boolean bl = isExpressionCompatible = !returnTypeIsVoid || TreeInfo.isExpressionStatement((JCTree.JCExpression)tree.getBody());
                        if (!isExpressionCompatible) {
                            this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleRetTypeInLambda(CompilerProperties.Fragments.MissingRetVal(currentReturnType))));
                        }
                    } else {
                        LambdaBodyStructChecker lambdaBodyChecker = new LambdaBodyStructChecker();
                        tree.body.accept(lambdaBodyChecker);
                        boolean isVoidCompatible = lambdaBodyChecker.isVoidCompatible;
                        if (returnTypeIsVoid) {
                            if (!isVoidCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.UnexpectedRetVal));
                            }
                        } else {
                            boolean isValueCompatible;
                            boolean bl = isValueCompatible = lambdaBodyChecker.isPotentiallyValueCompatible && !this.canLambdaBodyCompleteNormally(tree);
                            if (!isValueCompatible && !isVoidCompatible) {
                                DeferredAttr.this.log.error(tree.body.pos(), CompilerProperties.Errors.LambdaBodyNeitherValueNorVoidCompatible);
                            }
                            if (!isValueCompatible) {
                                this.resultInfo.checkContext.report(tree.pos(), DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleRetTypeInLambda(CompilerProperties.Fragments.MissingRetVal(currentReturnType))));
                            }
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean canLambdaBodyCompleteNormally(JCTree.JCLambda tree) {
                List<JCTree.JCVariableDecl> oldParams = tree.params;
                ArgumentAttr.LocalCacheContext localCacheContext = DeferredAttr.this.argumentAttr.withLocalCacheContext();
                try {
                    tree.params = tree.params.stream().map(vd -> DeferredAttr.this.make.VarDef(vd.mods, vd.name, DeferredAttr.this.make.Erroneous(), null)).collect(List.collector());
                    boolean bl = DeferredAttr.this.attribSpeculativeLambda((JCTree.JCLambda)tree, this.env, (Attr.ResultInfo)DeferredAttr.this.attr.unknownExprInfo).canCompleteNormally;
                    return bl;
                }
                finally {
                    localCacheContext.leave();
                    tree.params = oldParams;
                }
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitApply(JCTree.JCMethodInvocation tree) {
            }

            @Override
            public void visitConditional(JCTree.JCConditional tree) {
                this.scan(tree.truepart);
                this.scan(tree.falsepart);
            }

            @Override
            public void visitSwitchExpression(JCTree.JCSwitchExpression tree) {
                this.scan(tree.cases);
            }

            @Override
            public void visitReference(JCTree.JCMemberReference tree) {
                Assert.checkNonNull(tree.getOverloadKind());
                Check.CheckContext checkContext = this.resultInfo.checkContext;
                Type pt = this.resultInfo.pt;
                if (!this.inferenceContext.inferencevars.contains(pt)) {
                    Type descriptor = null;
                    try {
                        descriptor = DeferredAttr.this.types.findDescriptorType(pt);
                    }
                    catch (Types.FunctionDescriptorLookupError ex) {
                        checkContext.report(null, ex.getDiagnostic());
                    }
                    Env<AttrContext> localEnv = this.env.dup(tree);
                    JCTree.JCExpression exprTree = (JCTree.JCExpression)DeferredAttr.this.attribSpeculative(tree.getQualifierExpression(), localEnv, DeferredAttr.this.attr.memberReferenceQualifierResult(tree), DeferredAttr.this.argumentAttr.withLocalCacheContext());
                    ListBuffer<Type.JCNoType> argtypes = new ListBuffer<Type.JCNoType>();
                    for (Type t : descriptor.getParameterTypes()) {
                        argtypes.append(Type.noType);
                    }
                    JCTree.JCMemberReference mref2 = new TreeCopier(DeferredAttr.this.make).copy(tree);
                    mref2.expr = exprTree;
                    Symbol lookupSym = (Symbol)DeferredAttr.this.rs.resolveMemberReference(localEnv, (JCTree.JCMemberReference)mref2, (Type)exprTree.type, (Name)tree.name, argtypes.toList(), List.nil(), (Type)descriptor, (Resolve.MethodCheck)DeferredAttr.this.rs.arityMethodCheck, (InferenceContext)this.inferenceContext, (Resolve.ReferenceChooser)DeferredAttr.this.rs.structuralReferenceChooser).fst;
                    switch (lookupSym.kind) {
                        case WRONG_MTH: 
                        case WRONG_MTHS: {
                            checkContext.report(tree, DeferredAttr.this.diags.fragment(CompilerProperties.Fragments.IncompatibleArgTypesInMref));
                            break;
                        }
                        case ABSENT_MTH: 
                        case STATICERR: {
                            checkContext.report(tree, ((Resolve.ResolveError)lookupSym).getDiagnostic(JCDiagnostic.DiagnosticType.FRAGMENT, tree, exprTree.type.tsym, exprTree.type, tree.name, argtypes.toList(), List.nil()));
                        }
                    }
                }
            }
        }

        class LambdaBodyStructChecker
        extends TreeScanner {
            boolean isVoidCompatible = true;
            boolean isPotentiallyValueCompatible = true;

            LambdaBodyStructChecker() {
            }

            @Override
            public void visitClassDef(JCTree.JCClassDecl tree) {
            }

            @Override
            public void visitLambda(JCTree.JCLambda tree) {
            }

            @Override
            public void visitNewClass(JCTree.JCNewClass tree) {
            }

            @Override
            public void visitReturn(JCTree.JCReturn tree) {
                if (tree.expr != null) {
                    this.isVoidCompatible = false;
                } else {
                    this.isPotentiallyValueCompatible = false;
                }
            }
        }
    }

    public class DeferredType
    extends Type {
        public JCTree.JCExpression tree;
        Env<AttrContext> env;
        AttrMode mode;
        Set<Symbol> notPertinentToApplicability;
        SpeculativeCache speculativeCache;

        DeferredType(JCTree.JCExpression tree, Env<AttrContext> env) {
            super(null, List.nil());
            this.notPertinentToApplicability = new HashSet<Symbol>();
            this.tree = tree;
            this.env = DeferredAttr.this.attr.copyEnv(env);
            this.speculativeCache = new SpeculativeCache();
        }

        @Override
        public TypeTag getTag() {
            return TypeTag.DEFERRED;
        }

        @Override
        public String toString() {
            return "DeferredType";
        }

        Type speculativeType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            SpeculativeCache.Entry e = this.speculativeCache.get(msym, phase);
            return e != null ? e.speculativeTree.type : Type.noType;
        }

        JCTree speculativeTree(DeferredAttrContext deferredAttrContext) {
            SpeculativeCache.Entry e = this.speculativeCache.get(deferredAttrContext.msym, deferredAttrContext.phase);
            return e != null ? e.speculativeTree : DeferredAttr.this.stuckTree;
        }

        public Type complete(Attr.ResultInfo resultInfo, DeferredAttrContext deferredAttrContext) {
            switch (deferredAttrContext.mode.ordinal()) {
                case 0: {
                    Assert.check(this.mode == null || this.mode == AttrMode.SPECULATIVE);
                    JCTree speculativeTree = DeferredAttr.this.attribSpeculative(this.tree, this.env, resultInfo);
                    this.speculativeCache.put(speculativeTree, resultInfo);
                    return speculativeTree.type;
                }
                case 1: {
                    Assert.check(this.mode != null);
                    return DeferredAttr.this.attr.attribTree(this.tree, this.env, resultInfo);
                }
            }
            Assert.error();
            return null;
        }

        Type check(Attr.ResultInfo resultInfo) {
            DeferredStuckPolicy deferredStuckPolicy = resultInfo.pt.hasTag(TypeTag.NONE) || resultInfo.pt.isErroneous() ? DeferredAttr.this.dummyStuckPolicy : (resultInfo.checkContext.deferredAttrContext().mode == AttrMode.SPECULATIVE || resultInfo.checkContext.deferredAttrContext().insideOverloadPhase() ? new OverloadStuckPolicy(resultInfo, this) : new CheckStuckPolicy(resultInfo, this));
            return this.check(resultInfo, deferredStuckPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Type check(Attr.ResultInfo resultInfo, DeferredStuckPolicy deferredStuckPolicy) {
            DeferredAttrContext deferredAttrContext = resultInfo.checkContext.deferredAttrContext();
            Assert.check(deferredAttrContext != DeferredAttr.this.emptyDeferredAttrContext);
            if (deferredStuckPolicy.isStuck()) {
                deferredAttrContext.addDeferredAttrNode(this, resultInfo, deferredStuckPolicy);
                if (deferredAttrContext.mode == AttrMode.SPECULATIVE) {
                    this.notPertinentToApplicability.add(deferredAttrContext.msym);
                    this.mode = AttrMode.SPECULATIVE;
                }
                return Type.noType;
            }
            try {
                Type type = this.complete(resultInfo, deferredAttrContext);
                return type;
            }
            finally {
                this.mode = deferredAttrContext.mode;
            }
        }

        class SpeculativeCache {
            private Map<Symbol, List<Entry>> cache = new WeakHashMap<Symbol, List<Entry>>();

            SpeculativeCache() {
            }

            Entry get(Symbol msym, Resolve.MethodResolutionPhase phase) {
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    return null;
                }
                for (Entry e : entries) {
                    if (!e.matches(phase)) continue;
                    return e;
                }
                return null;
            }

            void put(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                Symbol msym = resultInfo.checkContext.deferredAttrContext().msym;
                List<Entry> entries = this.cache.get(msym);
                if (entries == null) {
                    entries = List.nil();
                }
                this.cache.put(msym, entries.prepend(new Entry(speculativeTree, resultInfo)));
            }

            class Entry {
                JCTree speculativeTree;
                Attr.ResultInfo resultInfo;

                public Entry(JCTree speculativeTree, Attr.ResultInfo resultInfo) {
                    this.speculativeTree = speculativeTree;
                    this.resultInfo = resultInfo;
                }

                boolean matches(Resolve.MethodResolutionPhase phase) {
                    return this.resultInfo.checkContext.deferredAttrContext().phase == phase;
                }
            }
        }
    }
}

