/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.fips;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.SocketChannel;
import java.util.Set;
import org.apache.knox.gateway.fips.BCInterceptingOutputStream;

public class BCInterceptingSocket
extends Socket {
    private final Socket delegate;

    public BCInterceptingSocket(Socket delegate) throws IOException {
        this.delegate = delegate;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        OutputStream originalOutputStream = this.delegate.getOutputStream();
        return new BCInterceptingOutputStream(originalOutputStream);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.delegate.getInputStream();
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.delegate.connect(endpoint);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.delegate.connect(endpoint, timeout);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        this.delegate.bind(bindpoint);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.delegate.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.delegate.isOutputShutdown();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.delegate.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.delegate.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.delegate.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.delegate.getRemoteSocketAddress();
    }

    @Override
    public boolean isBound() {
        return this.delegate.isBound();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.delegate.getReuseAddress();
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.delegate.setReuseAddress(on);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.delegate.getTrafficClass();
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.delegate.setTrafficClass(tc);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.delegate.getKeepAlive();
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.delegate.setKeepAlive(on);
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.delegate.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.delegate.getChannel();
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.delegate.setTcpNoDelay(on);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.delegate.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.delegate.setSoLinger(on, linger);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.delegate.getSoLinger();
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        this.delegate.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.delegate.setOOBInline(on);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.delegate.getOOBInline();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.delegate.setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.delegate.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.delegate.setSendBufferSize(size);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.delegate.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.delegate.setReceiveBufferSize(size);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.delegate.getReceiveBufferSize();
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        this.delegate.setPerformancePreferences(connectionTime, latency, bandwidth);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return (Set)this.invokeDelegateMethod("supportedOptions", new Class[0], new Object[0]);
    }

    @Override
    public <T> T getOption(SocketOption<T> name) throws IOException {
        return this.invokeDelegateMethod("getOption", new Class[]{SocketOption.class}, name);
    }

    @Override
    public <T> Socket setOption(SocketOption<T> name, T value) throws IOException {
        return (Socket)this.invokeDelegateMethod("setOption", new Class[]{SocketOption.class, Object.class}, name, value);
    }

    private <T> T invokeDelegateMethod(String methodName, Class<?>[] parameterTypes, Object ... args) {
        try {
            return (T)this.delegate.getClass().getMethod(methodName, parameterTypes).invoke((Object)this.delegate, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Socket option not supported", e);
        }
    }
}

